<?php

namespace App\Livewire\User;

use App\Models\AppNotification;
use Livewire\Attributes\On;
use Livewire\Component;

class ViewErrorModal extends Component
{
    public $showModal = false;

    public $notificationTitle = '';

    public $errorMessage = '';

    public $failedAt = '';

    #[On('view-error')]
    public function show(int $id): void
    {
        $notification = AppNotification::where('id', $id)
            ->where('user_id', auth()->id())
            ->where('status', 'failed')
            ->first();

        if (! $notification) {
            return;
        }

        $this->notificationTitle = $notification->title;
        $this->errorMessage = $notification->error_message ?? __('user.notification_error_unknown');
        $this->failedAt = $notification->updated_at?->format('M d, Y g:i A') ?? '';
        $this->showModal = true;
    }

    public function close(): void
    {
        $this->showModal = false;
        $this->reset(['notificationTitle', 'errorMessage', 'failedAt']);
    }

    public function render()
    {
        return view('livewire.user.view-error-modal');
    }
}
