<?php

namespace App\Plugins\Platforms\AndroidWebView\Livewire;

use App\Models\Keystore;
use Livewire\Attributes\On;
use Livewire\Component;

class DeleteKeystoreModal extends Component
{
    public $showModal = false;

    public $keystoreId = null;

    public $keystoreName = '';

    #[On('delete-keystore')]
    public function openModal($id, $name)
    {
        $this->keystoreId = $id;
        $this->keystoreName = $name;
        $this->showModal = true;
    }

    public function confirmDelete()
    {
        try {
            $keystore = Keystore::where('user_id', auth()->id())->findOrFail($this->keystoreId);
            $keystore->delete();

            $this->showModal = false;
            $this->reset(['keystoreId', 'keystoreName']);

            $this->dispatch('show-toast',
                type: 'success',
                message: __('platform.toast.keystore_deleted')
            );

            $this->dispatch('keystore-deleted');

        } catch (\Exception $e) {
            $this->dispatch('show-toast',
                type: 'error',
                message: __('platform.toast.keystore_delete_failed')
            );
        }
    }

    public function closeModal()
    {
        $this->showModal = false;
        $this->reset(['keystoreId', 'keystoreName']);
    }

    public function render()
    {
        return view('plugins.android-webview::livewire.delete-keystore-modal');
    }
}
