<?php

namespace App\Plugins\Platforms\AndroidWebView\Livewire;

use App\Models\App;
use Livewire\Attributes\On;
use Livewire\Component;

class DeleteSplashscreenLogoModal extends Component
{
    public App $app;

    public $showModal = false;

    #[On('delete-splashscreen-logo')]
    public function openModal()
    {
        $this->showModal = true;
    }

    public function confirmDelete()
    {
        try {
            if ($this->app->androidWebViewConfig->splashscreen_logo) {
                \Storage::disk('public')->delete($this->app->androidWebViewConfig->splashscreen_logo);

                $this->app->androidWebViewConfig->update(['splashscreen_logo' => null]);

                $this->showModal = false;

                $this->dispatch('show-toast',
                    type: 'success',
                    message: __('platform.toast.splashscreen_logo_deleted')
                );

                $this->dispatch('settings-updated');
            }
        } catch (\Exception $e) {
            $this->dispatch('show-toast',
                type: 'error',
                message: __('platform.toast.splashscreen_logo_delete_failed')
            );
        }
    }

    public function closeModal()
    {
        $this->showModal = false;
    }

    public function render()
    {
        return view('plugins.android-webview::livewire.delete-splashscreen-logo-modal');
    }
}
