<?php

return [
    // Page Titles
    'admin_overview' => 'نظرة عامة للمدير',
    'overview_title' => 'نظرة عامة',
    'users_title' => 'المستخدمون',
    'subscriptions_title' => 'الاشتراكات',
    'transactions_title' => 'المعاملات',
    'plans_title' => 'الخطط',
    'builders_title' => 'أدوات البناء',
    'plugins_title' => 'الإضافات',
    'languages_title' => 'اللغات',
    'cronjobs_title' => 'المهام المجدولة',
    'email_templates_title' => 'قوالب البريد الإلكتروني',
    'audit_logs_title' => 'سجلات التدقيق',
    'settings_title' => 'الإعدادات',

    // Page Subtitles
    'users_subtitle' => 'إدارة مستخدمي المنصة والحسابات',
    'subscriptions_subtitle' => 'مراقبة اشتراكات المستخدمين والفوترة',
    'transactions_subtitle' => 'عرض وإدارة معاملات الدفع',
    'plans_subtitle' => 'تكوين خطط الاشتراك والأسعار',
    'builders_subtitle' => 'إدارة أدوات بناء التطبيقات',
    'plugins_subtitle' => 'إدارة الإضافات المثبتة',
    'languages_subtitle' => 'إدارة اللغات المتاحة',
    'cronjobs_subtitle' => 'مراقبة المهام المجدولة',
    'email_templates_subtitle' => 'تخصيص إشعارات البريد الإلكتروني المرسلة للمستخدمين',
    'cronjobs_subtitle_full' => 'مراقبة المهام المجدولة والأتمتة',
    'settings_subtitle_full' => 'تكوين الإعدادات والتفضيلات على مستوى النظام',
    'search_settings' => 'البحث في الإعدادات...',
    'no_settings_found' => 'لم يتم العثور على إعدادات مطابقة',
    'system_settings' => 'إعدادات النظام',
    'clear_search' => 'مسح البحث',

    // Settings Sidebar Navigation
    'settings_section_general' => 'عام',
    'settings_section_plans' => 'الخطط',
    'settings_section_auth' => 'المصادقة',
    'settings_section_email' => 'البريد الإلكتروني',
    'settings_section_privacy' => 'الخصوصية',
    'settings_section_preview' => 'المعاينة',
    'settings_section_ai' => 'دردشة الذكاء الاصطناعي',
    'settings_category_platform' => 'المنصة',
    'settings_category_security' => 'الأمان',
    'settings_category_integrations' => 'التكاملات',
    'audit_logs_subtitle' => 'تتبع إجراءات المستخدمين وأحداث النظام للامتثال للائحة حماية البيانات',
    'no_audit_logs_found' => 'لم يتم العثور على سجلات تدقيق.',
    'search_audit_logs' => 'البحث بالمستخدم، الإجراء، عنوان IP...',
    'date_time' => 'التاريخ/الوقت',
    'actor' => 'المنفذ',
    'ip_address' => 'عنوان IP',
    'details' => 'التفاصيل',
    'view_details' => 'عرض التفاصيل',
    'system' => 'النظام',
    'clear_filters' => 'مسح الفلاتر',
    'to' => 'إلى',
    'settings_subtitle' => 'تكوين إعدادات النظام',

    // Users
    'add_user' => 'إضافة مستخدم',
    'edit_user' => 'تعديل المستخدم',
    'create_user' => 'إنشاء مستخدم',
    'delete_user' => 'حذف المستخدم',
    'user_info' => 'معلومات المستخدم',
    'user_details' => 'تفاصيل المستخدم',
    'no_users_found' => 'لم يتم العثور على مستخدمين.',
    'search_users' => 'البحث عن مستخدمين...',
    'user_role' => 'الدور',
    'user_plan' => 'الخطة',
    'user_joined' => 'تاريخ الانضمام',
    'email_verified' => 'البريد الإلكتروني موثق',
    'mark_email_verified' => 'تعيين البريد الإلكتروني كموثق',
    'role_admin' => 'مدير',
    'role_user' => 'مستخدم',
    'leave_blank_password' => 'اتركه فارغاً للإبقاء على كلمة المرور الحالية',

    // Plans
    'add_plan' => 'إضافة خطة',
    'edit_plan' => 'تعديل الخطة',
    'create_plan' => 'إنشاء خطة',
    'create_new_plan' => 'إنشاء خطة جديدة',
    'update_plan' => 'تحديث الخطة',
    'delete_plan' => 'حذف الخطة',
    'no_plans_found' => 'لم يتم العثور على خطط.',
    'plan_features' => 'المميزات',
    'plan_price' => 'السعر',
    'plan_interval' => 'فترة الفوترة',
    'monthly' => 'شهرياً',
    'yearly' => 'سنوياً',
    'default_plan' => 'الخطة الافتراضية',
    'mark_as_default' => 'تعيين كخطة افتراضية',
    'per_month' => '/شهر',
    'subscribers' => 'مشتركين',
    'plan_name' => 'اسم الخطة',
    'plan_name_placeholder' => 'احترافية',
    'basic_information' => 'المعلومات الأساسية',
    'usage_limits' => 'حدود الاستخدام',
    'monthly_build_credits' => 'رصيد البناء الشهري',
    'unlimited' => 'غير محدود',
    'appetize_preview' => 'معاينة Appetize',
    'hosted_pages' => 'الصفحات المستضافة',
    'ai_assistant' => 'مساعد الذكاء الاصطناعي',
    'allow_own_api_keys' => 'السماح بمفاتيح API الخاصة',
    'permissions' => 'الصلاحيات',
    'custom_css_js_injection' => 'حقن CSS/JS مخصص',
    'api_access' => 'الوصول لواجهة API',
    'builder_access' => 'الوصول لأدوات البناء',
    'all_builders_allowed' => 'جميع أدوات البناء مسموحة',
    'select_builders' => 'اختر أدوات البناء',
    'builders_selected' => ':count أداة بناء محددة',
    'allow_all_builders' => 'السماح بجميع أدوات البناء',
    'search_builders_placeholder' => 'البحث عن أدوات البناء...',
    'features_pricing_display' => 'المميزات (عرض الأسعار)',
    'feature_name' => 'اسم الميزة',
    'included' => 'مشمولة',
    'not_included' => 'غير مشمولة',
    'no_features_added' => 'لم تتم إضافة مميزات بعد. أضف مميزات لعرضها في صفحة الأسعار.',

    // Subscriptions
    'add_subscription' => 'إضافة اشتراك',
    'subscription_details' => 'تفاصيل الاشتراك',
    'no_subscriptions_found' => 'لم يتم العثور على اشتراكات.',
    'search_subscriptions' => 'البحث عن اشتراكات...',
    'renewal_date' => 'تاريخ التجديد',
    'subscription_status' => 'الحالة',
    'change_plan' => 'تغيير الخطة',
    'cancel_subscription' => 'إلغاء الاشتراك',
    'next_billing' => 'الفاتورة التالية',
    'no_plan' => 'لا توجد خطة',
    'select_user' => 'اختر مستخدماً',
    'select_plan' => 'اختر خطة',
    'payment_method_placeholder' => 'يدوي، تحويل بنكي، إلخ.',

    // Transactions
    'transaction_details' => 'تفاصيل المعاملة',
    'no_transactions_found' => 'لم يتم العثور على معاملات.',
    'search_transactions' => 'البحث عن معاملات...',
    'transaction_id' => 'المعرف',
    'transaction_date' => 'التاريخ',
    'transaction_amount' => 'المبلغ',
    'payment_method' => 'طريقة الدفع',
    'payment_gateway' => 'بوابة الدفع',
    'transaction_status' => 'الحالة',
    'approve' => 'موافقة',
    'decline' => 'رفض',
    'confirm_approval' => 'تأكيد الموافقة',
    'confirm_decline' => 'تأكيد الرفض',
    'approve_payment' => 'الموافقة على الدفع',
    'decline_payment' => 'رفض الدفع',
    'approve_bank_transfer_confirm' => 'هل أنت متأكد من الموافقة على هذا التحويل البنكي؟ سيؤدي ذلك إلى تفعيل اشتراك المستخدم.',
    'decline_bank_transfer_confirm' => 'هل أنت متأكد من رفض هذا التحويل البنكي؟ سيؤدي ذلك إلى إلغاء الاشتراك وإشعار المستخدم.',

    // Builders
    'add_builder' => 'إضافة أداة بناء',
    'edit_builder' => 'تعديل أداة البناء',
    'create_builder' => 'إنشاء أداة بناء',
    'delete_builder' => 'حذف أداة البناء',
    'no_builders_found' => 'لم يتم العثور على أدوات بناء.',
    'search_builders' => 'البحث عن أدوات البناء...',
    'builder_name' => 'اسم أداة البناء',
    'builder_url' => 'الرابط',
    'builder_status' => 'الحالة',
    'builder_platform' => 'المنصة',
    'builder_platforms' => 'المنصات',
    'builder_name_placeholder' => 'أداة البناء الإنتاجية',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'مفتاح الخادم المُنشأ',
    'builder_queue' => 'قائمة الانتظار',
    'current_builds' => 'البناءات الحالية',
    'total_builds' => 'إجمالي البناءات',
    'server_url' => 'رابط الخادم',
    'port' => 'المنفذ',
    'server_key' => 'مفتاح الخادم',
    'server_key_help' => 'يُستخدم للمصادقة على طلبات API لأداة البناء هذه',
    'generate' => 'إنشاء',
    'max_queue' => 'الحد الأقصى لقائمة الانتظار',
    'max_queue_help' => 'الحد الأقصى للبناءات المتزامنة',
    'build_credit_cost' => 'تكلفة رصيد البناء',
    'credit_cost_help' => 'الرصيد المخصوم لكل عملية بناء',
    'supported_platforms' => 'المنصات المدعومة',
    'select_platforms' => 'اختر المنصات',
    'platforms_selected' => ':count منصة محددة',
    'platforms_help' => 'اختر منصة واحدة أو أكثر تدعمها أداة البناء هذه',
    'no_platforms_available' => 'لا توجد منصات متاحة',
    'no_builders_configured' => 'لم يتم تكوين أدوات بناء بعد.',
    'default' => 'افتراضي',
    'locked' => 'مقفل',
    'from_purchase_code' => 'من رمز الشراء',
    'purchase_code_not_set_warning' => 'رمز الشراء غير مكون',
    'purchase_code_not_set_description' => 'تتطلب أداة البناء الافتراضية رمز شراء صالح. يرجى تكوينه في الإعدادات > عام.',
    'server_key_from_purchase_code_help' => 'يتم تعيين مفتاح الخادم تلقائيًا من رمز الشراء الخاص بك.',

    // Plugins
    'upload_plugin' => 'رفع إضافة',
    'configure_plugin' => 'تكوين',
    'delete_plugin' => 'حذف الإضافة',
    'no_plugins_found' => 'لم يتم العثور على إضافات.',
    'plugin_name' => 'الاسم',
    'plugin_version' => 'الإصدار',
    'plugin_type' => 'النوع',
    'plugin_status' => 'الحالة',

    // Languages
    'add_language' => 'إضافة لغة',
    'add_new_language' => 'إضافة لغة جديدة',
    'edit_language' => 'تعديل اللغة',
    'create_language' => 'إنشاء لغة',
    'delete_language' => 'حذف اللغة',
    'no_languages_found' => 'لم يتم العثور على لغات.',
    'cannot_delete_default_language' => 'لا يمكن حذف اللغة الافتراضية أو الأساسية.',
    'default_language_badge' => 'افتراضية',
    'language_name' => 'اسم اللغة',
    'language_code' => 'رمز اللغة',
    'language_code_help' => 'رمز ISO 639-1 المكون من حرفين (مثل: en، es، fr)',
    'language_code_from_folder' => 'اختر من مجلدات الترجمة المتاحة',
    'language_flag' => 'العلم',
    'language_flag_help' => 'رمز علم الدولة',
    'language_flag_auto' => 'يتم تعيين العلم تلقائياً بناءً على رمز اللغة',
    'language_flag_country_code_help' => 'رمز الدولة المكون من حرفين (مثل: us، gb، es)',
    'language_name_placeholder' => 'العربية',
    'language_code_placeholder' => 'ar',
    'language_flag_placeholder' => '🇸🇦',
    'language_status' => 'الحالة',
    'rtl_support' => 'اتجاه النص',
    'rtl_enabled' => 'من اليمين إلى اليسار (RTL)',
    'rtl_description' => 'تفعيل للغات مثل العربية والعبرية والفارسية والأردية',
    'translation_files_created' => 'سيتم إنشاء ملفات الترجمة في: lang/:code/',
    'translation_files_auto_created' => 'تأكد من وجود ملفات الترجمة في :path قبل إضافة هذه اللغة. انسخ مجلد lang/en/ وأعد تسميته برمز لغتك وترجم المحتويات.',

    // Email Templates
    'edit_template' => 'تعديل القالب',
    'edit_email_template' => 'تعديل قالب البريد الإلكتروني',
    'reset_template' => 'إعادة التعيين للافتراضي',
    'no_templates_found' => 'لم يتم العثور على قوالب.',
    'template_subject' => 'الموضوع',
    'template_body' => 'المحتوى',
    'template_variables' => 'المتغيرات المتاحة',
    'subject_line' => 'سطر الموضوع',
    'email_subject_placeholder' => 'موضوع البريد الإلكتروني...',
    'email_body' => 'محتوى البريد الإلكتروني',
    'click_to_insert' => 'انقر للإدراج في موضع المؤشر',
    'no_variables_available' => 'لا توجد متغيرات متاحة لهذا القالب.',
    'quick_tips' => 'نصائح سريعة',
    'variables_replaced' => 'يتم استبدال المتغيرات بالبيانات الفعلية عند الإرسال',
    'toolbar_format_tip' => 'استخدم شريط الأدوات لتنسيق النص وإضافة روابط وإنشاء قوائم',
    'link_tip' => 'حدد النص وانقر على زر الرابط لإضافة روابط قابلة للنقر',

    // Cronjobs
    'no_cronjobs_found' => 'لم يتم العثور على مهام مجدولة.',
    'no_cron_logs_found' => 'لم يتم العثور على سجلات المهام المجدولة.',
    'search_logs' => 'البحث في السجلات...',
    'job_name' => 'اسم المهمة',
    'job' => 'المهمة',
    'last_run' => 'آخر تشغيل',
    'next_run' => 'التشغيل التالي',
    'run_duration' => 'المدة',
    'started' => 'بدأت',
    'duration' => 'المدة',
    'triggered_by' => 'تم تشغيلها بواسطة',
    'message' => 'الرسالة',
    'all_jobs' => 'جميع المهام',
    'trigger_manually' => 'تشغيل يدوي',
    'status_success' => 'نجاح',
    'status_running' => 'قيد التشغيل',

    // Settings
    'general_settings' => 'الإعدادات العامة',
    'email_settings' => 'إعدادات البريد الإلكتروني',
    'social_login_settings' => 'تسجيل الدخول الاجتماعي',
    'appetize_settings' => 'إعدادات Appetize',
    'ai_settings' => 'إعدادات الذكاء الاصطناعي',
    'gdpr_settings' => 'إعدادات GDPR',

    // General Settings Fields
    'site_name' => 'اسم الموقع',
    'site_description' => 'وصف الموقع',
    'site_tagline' => 'شعار الموقع',
    'logo' => 'الشعار',
    'logo_dark' => 'شعار الوضع الداكن',
    'favicon' => 'أيقونة الموقع',
    'default_theme' => 'المظهر الافتراضي',
    'landing_page_enabled' => 'تفعيل الصفحة الرئيسية',
    'system_currency' => 'عملة النظام',
    'default_language' => 'اللغة الافتراضية',
    'default_language_description' => 'اللغة الافتراضية للزوار الجدد والمستخدمين بدون تفضيل',

    // Status Labels
    'status_active' => 'نشط',
    'status_inactive' => 'غير نشط',
    'status_pending' => 'قيد الانتظار',
    'status_expired' => 'منتهي',
    'status_cancelled' => 'ملغى',
    'status_completed' => 'مكتمل',
    'status_failed' => 'فشل',

    // Demo Mode
    'demo_mode_notice' => 'لا يمكن تعديل الإعدادات في وضع العرض التوضيحي.',
    'disabled_in_demo' => 'معطل في وضع العرض التوضيحي',
    'hidden_in_demo' => 'مخفي في وضع العرض التوضيحي',

    // Plugins
    'plugins_title_full' => 'الإضافات',
    'plugins_subtitle_full' => 'توسيع الوظائف بإضافات مخصصة',
    'no_plugins_installed' => 'لا توجد إضافات مثبتة',
    'plugin_activate' => 'تفعيل',
    'plugin_deactivate' => 'إلغاء التفعيل',
    'plugin_uninstall' => 'إلغاء التثبيت',
    'plugin_author' => 'بواسطة :author',

    // Languages
    'languages_title_full' => 'اللغات',
    'languages_subtitle_full' => 'إدارة ترجمات اللغات والتوطين',

    // Cronjobs
    'cronjobs_title_full' => 'المهام المجدولة',
    'cronjobs_tab_jobs' => 'المهام المجدولة',
    'cronjobs_tab_logs' => 'سجلات التنفيذ',
    'execute_job' => 'تنفيذ',
    'executing_job' => 'جاري التنفيذ...',

    // Email Settings
    'email_config_title' => 'تكوين البريد الإلكتروني',
    'email_config_subtitle' => 'تكوين إعدادات البريد الإلكتروني وخادم SMTP',
    'mail_driver' => 'برنامج تشغيل البريد',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'يستخدم PHP Mail تكوين البريد المدمج في الخادم. بسيط ولكن قد يواجه مشاكل في التسليم على بعض الخوادم.',
    'php_mail_warning' => 'ملاحظة: بعض مزودي الاستضافة يعطلون وظيفة mail() في PHP. إذا لم يتم إرسال البريد الإلكتروني، فكر في التحويل إلى SMTP.',
    'smtp_config' => 'تكوين خادم SMTP',
    'smtp_host' => 'مضيف SMTP',
    'smtp_port' => 'منفذ SMTP',
    'smtp_username' => 'اسم مستخدم SMTP',
    'smtp_password' => 'كلمة مرور SMTP',
    'smtp_encryption' => 'التشفير',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'بدون',
    'admin_notifications' => 'إشعارات المدير',
    'admin_email' => 'بريد إشعارات المدير',
    'admin_email_help' => 'عنوان البريد الإلكتروني لاستلام إشعارات المدير. إذا كان فارغاً، سيتم استخدام بريد المدير المسجل.',
    'notify_user_registered' => 'تسجيل مستخدم جديد',
    'notify_subscription_created' => 'إنشاء اشتراك جديد',
    'notify_subscription_cancelled' => 'إلغاء الاشتراك',
    'notify_payment_received' => 'استلام دفعة',
    'notify_payment_failed' => 'فشل الدفع',
    'notify_build_started' => 'بدء البناء',
    'notify_build_completed' => 'اكتمال البناء',
    'notify_build_failed' => 'فشل البناء',
    'test_email' => 'بريد اختباري',
    'send_test_email' => 'إرسال بريد اختباري',
    'sending' => 'جاري الإرسال...',
    'mail_from_name' => 'اسم المرسل',
    'mail_from_address' => 'عنوان المرسل',
    'php_mail_info' => 'يستخدم PHP Mail تكوين البريد المدمج في الخادم (sendmail/postfix). لا يتطلب إعداداً إضافياً في هذه اللوحة.',
    'php_mail_switch_warning' => 'ملاحظة: بعض مزودي الاستضافة يعطلون وظيفة mail() في PHP. إذا فشل إرسال البريد الإلكتروني، انتقل إلى SMTP.',
    'admin_notifications_subtitle' => 'تكوين مكان إرسال إشعارات الدفع للمدير',
    'admin_email_description' => 'عنوان البريد الإلكتروني لاستلام إشعارات المدير. يُستخدم أيضاً للبريد الاختباري.',
    'notification_events' => 'أحداث الإشعارات',
    'notification_events_description' => 'حدد الأحداث التي يجب أن تُشغّل إشعارات المدير',
    'event_subscription_activated' => 'تفعيل الاشتراك',
    'event_payment_completed' => 'اكتمال الدفع',
    'event_payment_failed' => 'فشل الدفع',
    'event_subscription_cancelled' => 'إلغاء الاشتراك',
    'event_subscription_expired' => 'انتهاء الاشتراك',
    'event_bank_transfer_pending' => 'تحويل بنكي معلق',
    'event_user_registered' => 'تسجيل المستخدم',
    'event_build_completed' => 'اكتمال البناء',
    'event_build_failed' => 'فشل البناء',

    // Social Login Settings
    'auth_settings_title' => 'إعدادات المصادقة',
    'auth_settings_subtitle' => 'تكوين خيارات التسجيل وتسجيل الدخول الاجتماعي',
    'enable_registration' => 'تفعيل التسجيل',
    'enable_registration_description' => 'السماح للمستخدمين الجدد بإنشاء حسابات',
    'require_email_verification' => 'طلب التحقق من البريد الإلكتروني',
    'require_email_verification_description' => 'عند التعطيل، يتم التحقق من التسجيلات الجديدة تلقائياً',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'حماية نماذج المصادقة من الروبوتات',
    'recaptcha_site_key' => 'مفتاح الموقع',
    'recaptcha_site_key_placeholder' => 'مفتاح موقع reCAPTCHA v3 الخاص بك',
    'recaptcha_secret_key' => 'المفتاح السري',
    'recaptcha_secret_key_placeholder' => 'المفتاح السري لـ reCAPTCHA v3 الخاص بك',
    'leave_blank_keep_current' => 'اتركه فارغاً للإبقاء على الحالي',
    'google_login' => 'جوجل',
    'facebook_login' => 'فيسبوك',
    'github_login' => 'جيت هب',
    'client_id' => 'معرف العميل',
    'client_id_placeholder' => 'معرف عميل :provider الخاص بك',
    'client_secret' => 'سر العميل',
    'client_secret_placeholder' => 'سر عميل :provider الخاص بك',
    'app_id' => 'معرف التطبيق',
    'app_id_placeholder' => 'معرف تطبيق :provider الخاص بك',
    'app_secret' => 'سر التطبيق',
    'app_secret_placeholder' => 'سر تطبيق :provider الخاص بك',
    'callback_url' => 'رابط الاستدعاء',
    'oauth_help' => 'أنشئ بيانات اعتماد OAuth في وحدة تحكم مطوري :provider. استخدم رابط الاستدعاء أعلاه.',
    'test_connection' => 'اختبار الاتصال',
    'testing' => 'جاري الاختبار...',
    'configure_oauth' => 'تكوين بيانات اعتماد OAuth لـ :provider',
    'add_url_to_console' => 'أضف هذا الرابط إلى :provider الخاص بك',
    'leave_blank_keep_current' => 'اتركه فارغاً للإبقاء على الحالي',
    'your_provider_key' => ':type :provider الخاص بك',
    'recaptcha_help' => 'احصل على مفاتيحك من :link. تأكد من اختيار reCAPTCHA v3.',
    'recaptcha_console' => 'وحدة تحكم مدير Google reCAPTCHA',
    'get_api_key_from' => 'احصل على مفتاح API الخاص بك من :link',

    // General Settings
    'general_settings_title' => 'الإعدادات العامة',
    'general_settings_subtitle' => 'تحديث معلومات الموقع والعلامة التجارية',
    'site_name_label' => 'اسم الموقع',
    'site_description_label' => 'وصف الموقع',
    'site_description_placeholder' => 'يُستخدم لوصف الميتا وتحسين محركات البحث',
    'site_tagline_label' => 'شعار الموقع',
    'site_tagline_placeholder' => 'شعار قصير يظهر أسفل الشعار',
    'site_tagline_help' => 'يُعرض أسفل الشعار في الشريط الجانبي وصفحات تسجيل الدخول',
    'purchase_code_label' => 'رمز الشراء',
    'purchase_code_help' => 'ترخيصك أو رمز الشراء لهذا التثبيت (اختياري)',
    'logo_light' => 'الشعار (الوضع الفاتح)',
    'logo_dark_label' => 'الشعار (الوضع الداكن)',
    'delete_logo' => 'حذف الشعار',
    'delete_dark_logo' => 'حذف الشعار الداكن',
    'delete_favicon' => 'حذف أيقونة الموقع',
    'logo_help' => 'الحجم الموصى به: 200×50 بكسل (أفقي) أو 50×50 بكسل (مربع). PNG أو JPG أو SVG بخلفية شفافة. الحد الأقصى 2 ميجابايت.',
    'favicon_label' => 'أيقونة الموقع',
    'favicon_help' => 'الحجم الموصى به: 32×32 بكسل أو 16×16 بكسل. PNG أو ICO أو SVG. الحد الأقصى 1 ميجابايت.',
    'default_theme_label' => 'المظهر اللوني الافتراضي',
    'theme_system' => 'النظام (اتباع تفضيل جهاز المستخدم)',
    'theme_light' => 'فاتح',
    'theme_dark' => 'داكن',
    'theme_help' => 'المظهر الافتراضي للزوار الجدد. يمكن للمستخدمين تغييره في إعداداتهم.',
    'currency_label' => 'عملة النظام',
    'currency_help' => 'العملة المستخدمة لجميع الأسعار والمدفوعات. هذا يحدد بوابات الدفع المتاحة.',
    'landing_page_toggle' => 'تفعيل الصفحة الرئيسية العامة',
    'landing_page_help' => 'عند التعطيل، سيتم توجيه الزوار الذين يصلون إلى الرابط الرئيسي (/) إلى صفحة تسجيل الدخول',

    // Plan Configuration Settings
    'plan_config_title' => 'تكوين الخطة',
    'plan_config_subtitle' => 'تكوين إعدادات الخطة الافتراضية للمستخدمين الجدد',
    'default_plan_label' => 'الخطة الافتراضية',
    'default_plan_none' => 'لا شيء (يتطلب اشتراك)',
    'default_plan_help' => 'الخطة المعينة للمستخدمين الجدد عند التسجيل. إذا لم يتم اختيار خطة، سيحتاج المستخدمون للاشتراك للوصول إلى المميزات.',

    // AI Settings
    'ai_settings_title' => 'مساعد الدردشة بالذكاء الاصطناعي',
    'ai_settings_subtitle' => 'تكوين مساعد إنشاء التطبيقات بالذكاء الاصطناعي',
    'enable_ai' => 'تفعيل مساعد الدردشة بالذكاء الاصطناعي',
    'enable_ai_description' => 'السماح للمستخدمين بإنشاء وتكوين التطبيقات عبر محادثة الذكاء الاصطناعي',
    'enable_streaming' => 'تفعيل الردود المتدفقة',
    'enable_streaming_description' => 'بث ردود الذكاء الاصطناعي كلمة بكلمة لتجربة أكثر تفاعلية',
    'streaming_warning' => 'قد لا يعمل على جميع بيئات الاستضافة المشتركة',
    'ai_provider' => 'مزود الذكاء الاصطناعي',
    'ai_provider_help' => 'اختر بين OpenAI (GPT-4.1) أو Anthropic (Claude)',
    'api_key' => 'مفتاح API',
    'enter_api_key' => 'أدخل مفتاح API الخاص بك',
    'openai_console' => 'وحدة تحكم OpenAI',
    'anthropic_console' => 'وحدة تحكم Anthropic',
    'api_key_help' => 'احصل على مفتاح API الخاص بك من :provider',
    'advanced_settings' => 'الإعدادات المتقدمة',
    'ai_model' => 'نموذج الذكاء الاصطناعي',
    'ai_model_help' => 'حدد نموذج الذكاء الاصطناعي المستخدم لردود الدردشة',
    'temperature' => 'درجة الحرارة',
    'temperature_help' => 'يتحكم في العشوائية. أقل = أكثر تركيزاً، أعلى = أكثر إبداعاً',
    'max_tokens' => 'الحد الأقصى لرموز الرد',
    'max_tokens_help' => 'الحد الأقصى للرموز لكل رد ذكاء اصطناعي. قيم أعلى = ردود أطول لكن تكلفة أكثر',
    'auto_summarization' => 'التلخيص التلقائي',
    'enable_summarization' => 'تفعيل التلخيص التلقائي',
    'summarization_help' => 'تلخيص الرسائل القديمة تلقائياً لتقليل استخدام الرموز في المحادثات الطويلة',
    'summarization_threshold' => 'عتبة التلخيص',
    'summarization_threshold_help' => 'عدد الرسائل قبل تشغيل التلخيص التلقائي',
    'summarization_keep_recent' => 'الاحتفاظ بالرسائل الأخيرة',
    'summarization_keep_recent_help' => 'عدد الرسائل الأخيرة للاحتفاظ بها',
    'summarization_max_length' => 'الحد الأقصى لطول الملخص',
    'summarization_max_length_help' => 'الحد الأقصى لأحرف الملخص',
    'chat_widget' => 'أداة الدردشة',
    'widget_position' => 'موضع الأداة',
    'position_bottom_right' => 'أسفل اليمين',
    'position_bottom_left' => 'أسفل اليسار',
    'position_top_right' => 'أعلى اليمين',
    'position_top_left' => 'أعلى اليسار',
    'position_help' => 'مكان ظهور أداة دردشة الذكاء الاصطناعي في صفحة محرر التطبيق',

    // GDPR Settings
    'gdpr_settings_title' => 'إعدادات GDPR',
    'gdpr_settings_subtitle' => 'تكوين الامتثال لـ GDPR وإعدادات الخصوصية',
    'enable_cookie_consent' => 'تفعيل شريط الموافقة على ملفات تعريف الارتباط',
    'enable_data_export' => 'تفعيل تصدير البيانات',
    'enable_account_deletion' => 'تفعيل حذف الحساب',
    'deletion_grace_period' => 'فترة السماح لحذف الحساب (بالأيام)',
    'audit_log_retention' => 'الاحتفاظ بسجلات التدقيق (بالأيام)',

    // Appetize Settings
    'appetize_settings_title' => 'إعدادات Appetize',
    'appetize_settings_subtitle' => 'تكوين Appetize.io لمعاينات التطبيقات الحية',
    'appetize_api_token' => 'رمز API لـ Appetize',
    'appetize_api_token_help' => 'احصل على رمز API الخاص بك من لوحة تحكم Appetize.io',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'هل أنت متأكد من حذف',
    'delete_builder_confirm' => 'هل أنت متأكد من حذف',
    'delete_plan_confirm' => 'هل أنت متأكد من حذف خطة',
    'delete_plan_confirm_suffix' => '؟',
    'delete_language_confirm' => 'هل أنت متأكد من حذف',
    'delete_language_note' => 'لا يمكن التراجع عن هذا الإجراء. سيتم الاحتفاظ بملفات الترجمة لأمان البيانات.',
    'uninstall_plugin' => 'إلغاء تثبيت الإضافة',
    'uninstall_plugin_confirm' => 'هل أنت متأكد من إلغاء تثبيت',
    'cancel_subscription_confirm' => 'هل أنت متأكد من إلغاء الاشتراك لـ',
    'reset_email_template' => 'إعادة تعيين قالب البريد الإلكتروني',
    'reset_template_confirm' => 'هل أنت متأكد من إعادة تعيين',
    'reset_template_confirm_suffix' => 'إلى محتواه الافتراضي؟',
    'reset_template_warning' => 'ستفقد أي تخصيصات قمت بها.',
    'disabled_in_demo' => 'معطل في وضع العرض التوضيحي',

    // Plugin Upload Modal
    'plugin_file' => 'ملف الإضافة',
    'plugin_file_help' => 'ملف ZIP (الحد الأقصى 10 ميجابايت)',
    'installing_plugin' => 'جاري تثبيت الإضافة...',
    'installing' => 'جاري التثبيت...',

    // Plugin Config Modal
    'configure_plugin_title' => 'تكوين :name',
    'no_config_required' => 'لا يتطلب تكويناً',
    'no_config_required_desc' => 'هذه الإضافة لا تتطلب أي تكوين.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'تكامل Appetize.io',
    'appetize_integration_subtitle' => 'تكوين وظيفة معاينة التطبيق الحية',
    'enable_appetize_integration' => 'تفعيل تكامل Appetize.io',
    'enable_appetize_description' => 'السماح للمستخدمين بخطط Pro/Enterprise بمعاينة التطبيقات في المتصفح',
    'appetize_api_token_placeholder' => 'أدخل رمز API لـ Appetize.io',
    'appetize_api_token_link' => 'احصل على رمز API الخاص بك من',
    'auto_upload_builds' => 'الرفع التلقائي للبناءات إلى Appetize',
    'auto_upload_description' => 'رفع البناءات الناجحة تلقائياً للمعاينة الفورية',
    'preview_retention_days' => 'الاحتفاظ بالمعاينة (بالأيام)',
    'preview_retention_help' => 'حذف المعاينات القديمة بعد هذا العدد من الأيام لتوفير التكاليف (1-30 يوماً)',
    'session_timeout_seconds' => 'مهلة الجلسة (بالثواني)',
    'session_timeout_help' => 'مهلة عدم النشاط قبل انتهاء الجلسة',
    'seconds_30' => '30 ثانية',
    'minute_1' => 'دقيقة واحدة',
    'minutes_2' => 'دقيقتان',
    'minutes_3' => '3 دقائق',
    'minutes_5' => '5 دقائق',
    'minutes_10' => '10 دقائق',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'إعدادات GDPR والخصوصية',
    'gdpr_privacy_settings_subtitle' => 'تكوين حماية البيانات والامتثال للخصوصية',
    'feature_toggles' => 'تبديل المميزات',
    'cookie_consent_banner' => 'شريط الموافقة على ملفات تعريف الارتباط',
    'cookie_consent_description' => 'عرض شريط الموافقة على ملفات تعريف الارتباط للزوار الجدد',
    'user_data_export' => 'تصدير بيانات المستخدم',
    'user_data_export_description' => 'السماح للمستخدمين بطلب نسخة من بياناتهم',
    'user_account_deletion' => 'حذف حساب المستخدم',
    'user_account_deletion_description' => 'السماح للمستخدمين بطلب حذف الحساب',
    'policy_versions' => 'إصدارات السياسات',
    'policy_versions_help' => 'تحديث إصدارات السياسات سيُشغّل إعادة الموافقة للمستخدمين.',
    'privacy_policy' => 'سياسة الخصوصية',
    'terms_of_service' => 'شروط الخدمة',
    'cookie_policy' => 'سياسة ملفات تعريف الارتباط',
    'data_retention_periods' => 'فترات الاحتفاظ بالبيانات (بالأيام)',
    'retention_transactions' => 'المعاملات',
    'retention_transactions_help' => 'الحد الأدنى 365 يوماً (متطلب قانوني)',
    'retention_inactive_accounts' => 'الحسابات غير النشطة',
    'retention_expired_builds' => 'البناءات المنتهية',
    'retention_audit_logs' => 'سجلات التدقيق',
    'retention_data_exports' => 'تصديرات البيانات',
    'grace_periods_rate_limits' => 'فترات السماح وحدود المعدل',
    'account_deletion_grace_period' => 'فترة السماح لحذف الحساب (بالأيام)',
    'account_deletion_grace_help' => 'الوقت قبل حذف الحساب نهائياً',
    'data_export_rate_limit' => 'حد معدل تصدير البيانات (بالساعات)',
    'data_export_rate_limit_help' => 'الحد الأدنى للوقت بين طلبات التصدير',

    // App/Plan Settings
    'plan_configuration' => 'تكوين الخطة',
    'plan_configuration_subtitle' => 'تكوين إعدادات الخطة الافتراضية للمستخدمين الجدد',
    'default_plan_option_none' => 'لا شيء (يتطلب اشتراك)',
    'default_plan_description' => 'الخطة المعينة للمستخدمين الجدد. اختر "لا شيء" لطلب الاشتراك قبل الاستخدام.',

    // Overview Stats
    'overview_subtitle' => 'إحصائيات على مستوى النظام ومقاييس الإدارة',
    'date_range_today' => 'اليوم',
    'date_range_week' => 'الأسبوع',
    'date_range_month' => 'الشهر',
    'date_range_year' => 'السنة',
    'date_range_all' => 'كل الوقت',
    'auto_refresh' => 'التحديث التلقائي',
    'total_system_users' => 'إجمالي مستخدمي النظام',
    'active_subscriptions' => 'الاشتراكات النشطة',
    'revenue_label' => 'إيرادات :period',
    'total_apps' => 'إجمالي التطبيقات',
    'vs_last_month' => 'مقارنة بالشهر الماضي',
    'total_builds_stat' => 'إجمالي البناءات',
    'completed_today' => 'المكتملة اليوم',
    'build_success_rate' => 'معدل نجاح البناء',
    'pending_queue' => 'قائمة الانتظار',
    'total_transactions' => 'إجمالي المعاملات',
    'active_plans' => 'الخطط النشطة',
    'active_builders' => 'أدوات البناء النشطة',
    'revenue_trends' => 'اتجاهات الإيرادات (12 شهراً)',
    'build_activity' => 'نشاط البناء (آخر 30 يوماً)',
    'revenue_by_gateway' => 'الإيرادات حسب بوابة الدفع',
    'no_revenue_data' => 'لا توجد بيانات إيرادات متاحة بعد',
    'total_revenue' => 'إجمالي الإيرادات',
    'platform_distribution' => 'توزيع المنصات',
    'no_apps_created' => 'لم يتم إنشاء تطبيقات بعد',
    'pending_payments' => 'المدفوعات المعلقة',
    'active_users_7d' => 'المستخدمون النشطون (7 أيام)',
    'notifications_today' => 'الإشعارات (اليوم)',
    'build_performance_by_platform' => 'أداء البناء حسب المنصة',
    'platform' => 'المنصة',
    'completed' => 'مكتمل',
    'failed' => 'فشل',
    'success_rate' => 'معدل النجاح',
    'avg_duration' => 'متوسط المدة',
    'revenue_label_short' => 'الإيرادات',
    'builds_label' => 'البناءات',
    'recent_user_registrations' => 'التسجيلات الأخيرة',
    'no_users_yet' => 'لا يوجد مستخدمون بعد',
    'recent_builds' => 'البناءات الأخيرة',
    'no_builds_yet' => 'لا توجد بناءات بعد',
    'recent_transactions' => 'المعاملات الأخيرة',
    'no_transactions_yet' => 'لا توجد معاملات بعد',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'المهام',
    'cronjobs_tab_execution_logs' => 'سجلات التنفيذ',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'بيانات اعتماد API',
        'webhook_configuration' => 'تكوين Webhook',
        'webhook_url' => 'رابط Webhook',
        'copy' => 'نسخ',
        'copied' => 'تم النسخ!',
        'copy_failed' => 'فشل النسخ. يرجى تحديد ونسخ الرابط يدوياً.',
        'required_webhook_events' => 'أحداث Webhook المطلوبة',
        'features' => 'المميزات',
        'supported_features' => 'المميزات المدعومة',
        'secret_key' => 'المفتاح السري',
        'webhook_secret' => 'سر Webhook',
        'webhook_signing_secret' => 'سر توقيع Webhook',
        'optional' => 'اختياري',

        // SSL Warning
        'ssl_warning' => 'تحذير:',
        'ssl_warning_stripe' => 'موقعك لا يستخدم HTTPS. يتطلب Stripe استخدام HTTPS لـ webhooks والاستخدام الإنتاجي.',
        'ssl_warning_paypal' => 'موقعك لا يستخدم HTTPS. تتطلب webhooks الخاصة بـ PayPal اتصال HTTPS آمن. يرجى تفعيل SSL/TLS قبل الإطلاق.',
        'ssl_warning_paystack' => 'موقعك لا يستخدم HTTPS. تتطلب webhooks الخاصة بـ Paystack اتصال HTTPS آمن. يرجى تفعيل SSL/TLS قبل الإطلاق.',

        // Stripe
        'stripe' => [
            'get_started' => 'ابدأ مع Stripe',
            'get_api_keys' => 'احصل على مفاتيح API الخاصة بك من',
            'dashboard_link' => 'لوحة تحكم Stripe ← المطورون ← مفاتيح API',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'استخدم مفتاح الاختبار (sk_test_) للاختبار، المفتاح الحي (sk_live_) للإنتاج',
            'webhook_url_help' => 'أضف هذا الرابط في لوحة تحكم Stripe ← المطورون ← Webhooks',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'احصل على هذا بعد إنشاء نقطة نهاية webhook في لوحة تحكم Stripe',
            'events_help' => 'حدد هذه الأحداث عند إنشاء نقطة نهاية webhook:',
            'feature_currencies' => 'أكثر من 135 عملة مدعومة عالمياً',
            'feature_intervals' => 'جميع فترات الفوترة مدعومة',
            'feature_renewal' => 'تجديد الاشتراك التلقائي',
            'feature_customer_management' => 'إدارة العملاء',
            'feature_signature_verification' => 'التحقق من توقيع Webhook',
            'feature_refund' => 'معالجة الاسترداد',
            'feature_sca' => 'متوافق مع المصادقة القوية للعملاء (SCA)',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'معرف العميل',
            'client_id_help' => 'احصل على هذا من لوحة تحكم مطوري PayPal',
            'client_secret' => 'سر العميل',
            'client_secret_help' => 'حافظ على سرية هذا ولا تشاركه علناً أبداً',
            'sandbox_mode' => 'وضع Sandbox',
            'sandbox_mode_help' => 'فعّل للاختبار مع PayPal Sandbox. عطّل للمعاملات الحية.',
            'webhook_url_help' => 'أضف هذا الرابط إلى إعدادات webhook الخاصة بـ PayPal',
            'webhook_id' => 'معرف Webhook',
            'webhook_id_help' => 'معرف Webhook من لوحة تحكم PayPal للتحقق من التوقيع (مطلوب للأمان)',
            'events_help' => 'تأكد من تفعيل هذه الأحداث في تكوين webhook الخاص بـ PayPal:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'ابدأ مع Razorpay',
            'get_api_keys' => 'احصل على مفاتيح API الخاصة بك من',
            'dashboard_link' => 'لوحة تحكم Razorpay ← الإعدادات ← مفاتيح API',
            'key_id' => 'معرف المفتاح',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'استخدم مفتاح الاختبار (rzp_test_) للاختبار، المفتاح الحي (rzp_live_) للإنتاج',
            'key_secret' => 'سر المفتاح',
            'key_secret_help' => 'حافظ على سرية هذا ولا تشاركه علناً أبداً',
            'webhook_url_help' => 'أضف هذا الرابط في لوحة تحكم Razorpay ← الإعدادات ← Webhooks',
            'webhook_secret_placeholder' => 'أدخل سر webhook',
            'webhook_secret_help' => 'احصل على هذا من لوحة تحكم Razorpay بعد إنشاء webhook',
            'events_help' => 'فعّل هذه الأحداث في لوحة تحكم Razorpay ← الإعدادات ← Webhooks:',
            'feature_currencies' => 'أكثر من 100 عملة مدعومة',
            'feature_intervals' => 'جميع فترات الفوترة (يومية، أسبوعية، شهرية، سنوية)',
            'feature_payment_methods' => 'UPI، البطاقات، الخدمات المصرفية عبر الإنترنت، المحافظ، التقسيط',
            'feature_renewal' => 'تجديد الاشتراك التلقائي',
            'feature_signature_verification' => 'التحقق من توقيع Webhook',
            'feature_refund' => 'معالجة الاسترداد',
            'feature_decimal' => 'دعم العملات ذات ثلاث منازل عشرية (KWD، BHD، إلخ.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'ابدأ مع Paystack',
            'get_api_keys' => 'احصل على مفاتيح API الخاصة بك من',
            'dashboard_link' => 'لوحة تحكم Paystack ← الإعدادات ← مفاتيح API و Webhooks',
            'secret_key_help' => 'احصل على هذا من لوحة تحكم Paystack (استخدم مفتاح الاختبار للاختبار، المفتاح الحي للإنتاج)',
            'webhook_url_help' => 'أضف هذا الرابط إلى إعدادات webhook الخاصة بـ Paystack',
            'webhook_secret_help' => 'اختياري: للتحقق من توقيع webhook (موصى به للإنتاج)',
            'webhook_secret_placeholder' => 'اتركه فارغاً لتخطي التحقق من التوقيع',
            'events_help' => 'فعّل هذه الأحداث في لوحة تحكم Paystack ← الإعدادات ← مفاتيح API و Webhooks:',
            'feature_currencies' => 'العملات: NGN، USD، GHS، ZAR، KES',
            'feature_intervals' => 'الفترات: يومية، أسبوعية، شهرية (1، 3، 6 أشهر)، سنوية',
            'feature_renewal' => 'تجديد الاشتراك التلقائي',
            'feature_signature_verification' => 'التحقق من توقيع Webhook',
            'feature_interval_limitation' => 'دعم محدود للفترات (راجع الوثائق)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'ابدأ مع Crypto.com Pay',
            'get_api_keys' => 'احصل على بيانات اعتماد API الخاصة بك من',
            'dashboard_link' => 'لوحة تحكم Crypto.com Pay',
            'monthly_only_title' => 'الفترات الشهرية فقط',
            'monthly_only_description' => 'يدعم Crypto.com Pay حالياً فترات الفوترة الشهرية فقط. الاشتراكات اليومية والأسبوعية والسنوية غير مدعومة.',
            'secret_key_placeholder' => 'أدخل المفتاح السري لـ Crypto.com Pay',
            'secret_key_help' => 'احصل على هذا من لوحة تحكم Crypto.com Pay',
            'webhook_url_help' => 'أضف هذا الرابط إلى إعدادات webhook الخاصة بـ Crypto.com Pay',
            'webhook_secret_placeholder' => 'أدخل سر توقيع webhook',
            'webhook_secret_help' => 'مطلوب للتحقق من توقيع webhook',
            'events_help' => 'فعّل هذه الأحداث في لوحة تحكم Crypto.com Pay:',
            'feature_crypto_fiat' => 'قبول مدفوعات العملات المشفرة والتقليدية',
            'feature_currencies' => 'أكثر من 30 عملة مدعومة',
            'feature_renewal' => 'تجديد الاشتراك التلقائي',
            'feature_signature_verification' => 'التحقق من توقيع webhook باستخدام HMAC SHA-256',
            'feature_monthly_only' => 'الفترات الشهرية فقط (اليومية/الأسبوعية/السنوية غير مدعومة)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'الموافقة اليدوية مطلوبة',
            'manual_approval_description' => 'تتطلب مدفوعات التحويل البنكي التحقق اليدوي. سيرى المستخدمون التعليمات أدناه بعد بدء الدفع. يجب على المديرين الموافقة أو رفض المدفوعات في',
            'transactions_link' => 'المعاملات',
            'instructions_title' => 'تعليمات التحويل البنكي',
            'instructions_label' => 'تعليمات للمستخدمين',
            'instructions_placeholder' => "أدخل تفاصيل حسابك البنكي وتعليمات التحويل هنا...\n\nمثال:\n\nاسم البنك: بنك ABC\nاسم الحساب: اسم شركتك\nرقم الحساب: 123456789\nرمز Swift: ABCDEFGH\nالمرجع: [سيرى المستخدم معرف اشتراكه]\n\nيرجى تضمين معرف اشتراكك في مرجع الدفع وإرسال إثبات الدفع إلى billing@yourcompany.com",
            'instructions_help' => 'ستُعرض هذه التعليمات للمستخدمين بعد اختيارهم خطة. قم بتضمين تفاصيل الحساب البنكي وتنسيق المرجع وأي خطوات تحقق.',
            'workflow_title' => 'كيف تعمل مدفوعات التحويل البنكي:',
            'workflow_step_1' => 'يختار المستخدم خطة ويختار التحويل البنكي كطريقة دفع',
            'workflow_step_2' => 'يتم إنشاء اشتراك ومعاملة معلقين',
            'workflow_step_3' => 'يرى المستخدم التعليمات التي قمت بتكوينها أعلاه',
            'workflow_step_4' => 'يكمل المستخدم التحويل البنكي يدوياً',
            'workflow_step_5' => 'يتلقى المدير إشعاراً بالدفع المعلق',
            'workflow_step_6' => 'يوافق المدير على الدفع ← يتم تفعيل الاشتراك وإعادة ملء الرصيد',
            'workflow_step_7' => 'يرفض المدير الدفع ← يتم إزالة الاشتراك والمعاملة',
            'feature_currencies' => 'جميع العملات مدعومة',
            'feature_intervals' => 'جميع فترات الفوترة مدعومة (يومية، أسبوعية، شهرية، سنوية)',
            'feature_simple_setup' => 'إعداد بسيط - لا تتطلب بيانات اعتماد API',
            'feature_manual_verification' => 'التحقق اليدوي للأمان',
            'feature_no_fees' => 'لا رسوم معاملات أو اعتماد على طرف ثالث',
            'feature_admin_approval' => 'تتطلب موافقة المدير لكل دفعة',
            'feature_no_renewal' => 'لا تجديد تلقائي للاشتراك',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'رصيد بناء غير محدود',
    'feature_build_credits' => ':count رصيد بناء',
    'feature_all_builders' => 'الوصول لجميع أدوات البناء النشطة',
    'feature_builder_access' => 'الوصول لأدوات البناء',
    'feature_single_builder' => 'الوصول لأداة بناء واحدة',
    'feature_multiple_builders' => 'الوصول لـ :count أداة بناء',
    'feature_custom_code' => 'حقن CSS/JS مخصص',
    'feature_api_access' => 'الوصول لواجهة API',
    'feature_unlimited_hosted_pages' => 'صفحات مستضافة غير محدودة',
    'feature_hosted_pages' => ':count صفحة مستضافة لكل تطبيق',
    'feature_hosted_pages_disabled' => 'الصفحات المستضافة',
    'feature_unlimited_ai_chat' => 'دردشة ذكاء اصطناعي غير محدودة',
    'feature_ai_tokens' => ':count رمز ذكاء اصطناعي/شهر',
    'feature_own_ai_key' => 'استخدام مفتاح API الخاص للذكاء الاصطناعي',
    'feature_ai_chat' => 'مساعد دردشة الذكاء الاصطناعي',

    // Impersonation
    'impersonate' => 'انتحال',
    'impersonate_user' => 'انتحال شخصية المستخدم',
    'impersonation_started' => 'جاري انتحال شخصية :name',
    'impersonation_stopped' => 'انتهى الانتحال. مرحبًا بعودتك!',
    'impersonating_as' => 'تعرض كـ :name',
    'exit_impersonation' => 'خروج',
    'return_to_admin' => 'العودة للمسؤول',
    'not_impersonating' => 'لا تنتحل شخصية أي مستخدم حاليًا.',
    'admin_blocked_during_impersonation' => 'منطقة المسؤول محظورة أثناء الانتحال. اخرج من الانتحال أولاً.',
    'impersonation_disabled_demo' => 'الانتحال معطل في وضع العرض التوضيحي.',
    'only_admins_can_impersonate' => 'المسؤولون فقط يمكنهم انتحال شخصية المستخدمين.',
];
