<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Landing Page Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used throughout the landing page
    | components for various messages and labels.
    |
    */

    // Hero Section
    'hero' => [
        'pill_no_coding' => 'Aucun code requis',
        'pill_5_minute_setup' => 'Configuration en 5 minutes',
        'pill_free_tier' => 'Offre gratuite disponible',
        'headline' => 'Créez des applications natives',
        'headline_highlight' => 'en quelques minutes',
        'subheadline' => 'Transformez votre site web en applications natives pour toutes les plateformes.',
        'subheadline_ai' => 'Propulsé par l\'IA',
        'subheadline_features' => 'configuration, personnalisation de marque, notifications push et compilations automatisées. Aucun code requis.',
        'cta_get_started' => 'Commencer gratuitement',
        'cta_view_pricing' => 'Voir les tarifs',
        'stat_developers' => 'Développeurs',
        'stat_apps_built' => 'Applications créées',
        'stat_builds_generated' => 'Compilations générées',
        'rating_text' => '4,9/5 sur plus de 200 avis',
        'phone_app_name' => 'Mon App',
        'phone_app_type' => 'Mobile',
        'laptop_title' => 'Mon App — Tableau de bord',
    ],

    // Features Section
    'features' => [
        'title' => 'Tout ce dont vous avez besoin pour créer des applications exceptionnelles',
        'subtitle' => 'Des fonctionnalités puissantes et des outils pour transformer votre site web en applications natives professionnelles sans écrire une seule ligne de code.',

        'multi_platform_title' => 'Support multi-plateforme',
        'multi_platform_desc' => 'Créez des applications natives pour Android, Windows, macOS et Linux. Générez des packages spécifiques à chaque plateforme, prêts à être distribués sur n\'importe quelle boutique d\'applications.',

        'easy_config_title' => 'Configuration facile',
        'easy_config_desc' => 'Interface intuitive pour personnaliser le design de votre application, la navigation, les couleurs, les icônes, les écrans de démarrage et plus encore, sans aucun code requis.',

        'branding_title' => 'Contrôle total de la marque',
        'branding_desc' => 'Personnalisez les icônes, les écrans de démarrage, les thèmes, les couleurs et injectez du HTML, CSS et JavaScript personnalisé pour un contrôle total.',

        'push_notifications_title' => 'Notifications push',
        'push_notifications_desc' => 'Engagez vos utilisateurs avec les notifications push Firebase Cloud Messaging. Envoyez des messages ciblés à vos utilisateurs directement depuis votre tableau de bord.',

        'build_system_title' => 'Système de compilation automatisé',
        'build_system_desc' => 'Compilez vos applications en un seul clic. Notre système de compilation distribué génère automatiquement des packages spécifiques à chaque plateforme, prêts à être distribués.',

        'app_signing_title' => 'Signature d\'applications sécurisée',
        'app_signing_desc' => 'Téléversez et gérez vos certificats de signature en toute sécurité. Signez vos compilations de production pour la distribution sur les boutiques d\'applications en toute confiance.',

        'version_management_title' => 'Gestion des versions',
        'version_management_desc' => 'Gérez plusieurs versions d\'applications avec un historique des compilations. Suivez les modifications, revenez en arrière si nécessaire et maintenez le contrôle des versions sans effort.',

        'qr_testing_title' => 'Tests par QR code',
        'qr_testing_desc' => 'Testez vos applications instantanément avec des téléchargements par QR code. Partagez les compilations avec les testeurs et les clients avant de les publier sur les boutiques d\'applications.',

        'build_tracking_title' => 'Suivi des compilations',
        'build_tracking_desc' => 'Surveillez l\'état des compilations en temps réel avec des journaux détaillés. Suivez la durée des compilations, les erreurs et téléchargez les versions précédentes à tout moment.',

        'ai_assistant_title' => 'Assistant propulsé par l\'IA',
        'ai_assistant_desc' => 'Obtenez une aide intelligente pour configurer votre application. Notre assistant IA peut automatiquement configurer la navigation, les couleurs et les paramètres en fonction de votre site web.',

        'api_access_title' => 'Accès API',
        'api_access_desc' => 'Intégrez-vous à votre flux de travail grâce à notre API complète. Automatisez la création d\'applications, déclenchez des compilations et gérez les notifications de manière programmatique.',

        'hosted_pages_title' => 'Pages hébergées',
        'hosted_pages_desc' => 'Intégrez des pages HTML personnalisées directement dans votre application. Créez des pages À propos, FAQ, conditions d\'utilisation et plus encore avec un contrôle total du design.',
    ],

    // How It Works Section
    'how_it_works' => [
        'default_title' => 'Comment ça marche',
        'default_subtitle' => 'Créez votre application mobile en 4 étapes simples',

        'step1_title' => 'Entrez votre URL',
        'step1_desc' => 'Collez l\'URL de votre site web et nous l\'analyserons automatiquement pour vous aider à démarrer rapidement.',

        'step2_title' => 'Personnalisez le design',
        'step2_desc' => 'Choisissez les couleurs, icônes, écrans de démarrage et le style de navigation. Utilisez l\'assistance IA pour une configuration rapide.',

        'step3_title' => 'Compilez votre application',
        'step3_desc' => 'Compilation en un clic avec notre système distribué. Obtenez des compilations natives en quelques minutes.',

        'step4_title' => 'Téléchargez et publiez',
        'step4_desc' => 'Téléchargez votre application ou scannez le QR code pour la tester. Prête pour la publication sur les boutiques d\'applications.',
    ],

    // Pricing Section
    'pricing' => [
        'default_title' => 'Tarification simple et transparente',
        'default_description' => 'Choisissez le forfait parfait pour vos besoins. Tous les forfaits incluent les fonctionnalités de base avec différentes allocations de crédits de compilation.',
        'default_popular_badge' => 'Le plus populaire',
        'default_free_text' => 'Gratuit',
        'default_no_plans' => 'Les forfaits tarifaires arrivent bientôt. Veuillez revenir plus tard.',
        'start_free' => 'Commencer gratuitement',
        'go_pro' => 'Passer Pro',
        'get_enterprise' => 'Passer Enterprise',
    ],

    // Testimonials Section
    'testimonials' => [
        'default_title' => 'Ce que disent nos clients',
        'default_subtitle' => 'Rejoignez des milliers de développeurs et d\'entreprises satisfaits',
        'anonymous' => 'Anonyme',
    ],

    // CTA Section
    'cta' => [
        'title' => 'Commencez à créer votre application dès aujourd\'hui',
        'subtitle' => 'Rejoignez des milliers de développeurs et d\'entreprises qui font confiance à :site_name pour créer leurs applications. Aucune carte bancaire requise.',
        'button' => 'Commencer gratuitement',
    ],

    // Footer Section
    'footer' => [
        'tagline' => 'Créez des applications natives à partir de votre site web en quelques minutes. Créateur d\'applications professionnel sans code requis.',
        'privacy_policy' => 'Politique de confidentialité',
        'terms_of_service' => 'Conditions d\'utilisation',
        'cookie_policy' => 'Politique des cookies',
        'copyright' => '© :year. Tous droits réservés.',
    ],

    // Social Proof Section
    'social_proof' => [
        'happy_developers' => 'Développeurs satisfaits',
        'apps_created' => 'Applications créées',
        'builds_generated' => 'Compilations générées',
    ],

    // Logos Section
    'logos' => [
        'title' => 'Vous serez en bonne compagnie',
    ],

    // Page Titles
    'page_title' => 'Créez des applications mobiles natives en quelques minutes',
];
