<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Landing Page Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are used throughout the landing page
    | components for various messages and labels.
    |
    */

    // Hero Section
    'hero' => [
        'pill_no_coding' => 'コーディング不要',
        'pill_5_minute_setup' => '5分でセットアップ',
        'pill_free_tier' => '無料プランあり',
        'headline' => 'ネイティブアプリを',
        'headline_highlight' => '数分で作成',
        'subheadline' => 'ウェブサイトをあらゆるプラットフォーム向けのネイティブアプリに変換。',
        'subheadline_ai' => 'AI搭載の',
        'subheadline_features' => '設定、カスタムブランディング、プッシュ通知、自動ビルド。コーディング不要。',
        'cta_get_started' => '無料で始める',
        'cta_view_pricing' => '料金を見る',
        'stat_developers' => '開発者',
        'stat_apps_built' => '作成されたアプリ',
        'stat_builds_generated' => '生成されたビルド',
        'rating_text' => '200件以上のレビューで4.9/5',
        'phone_app_name' => 'マイアプリ',
        'phone_app_type' => 'モバイル',
        'laptop_title' => 'マイアプリ — ダッシュボード',
    ],

    // Features Section
    'features' => [
        'title' => '素晴らしいアプリを作成するために必要なすべて',
        'subtitle' => 'コードを1行も書かずに、ウェブサイトをプロフェッショナルなネイティブアプリケーションに変換するための強力な機能とツール。',

        'multi_platform_title' => 'マルチプラットフォーム対応',
        'multi_platform_desc' => 'Android、Windows、macOS、Linux向けのネイティブアプリを構築。あらゆるアプリストアで配布可能なプラットフォーム固有のパッケージを生成。',

        'easy_config_title' => '簡単な設定',
        'easy_config_desc' => 'コーディング不要で、アプリのデザイン、ナビゲーション、色、アイコン、スプラッシュスクリーンなどをカスタマイズできる直感的なインターフェース。',

        'branding_title' => '完全なブランディングコントロール',
        'branding_desc' => 'アプリアイコン、スプラッシュスクリーン、テーマ、色をカスタマイズし、カスタムHTML、CSS、JavaScriptを注入して完全にコントロール。',

        'push_notifications_title' => 'プッシュ通知',
        'push_notifications_desc' => 'Firebase Cloud Messagingのプッシュ通知でユーザーにエンゲージ。ダッシュボードから直接ターゲットを絞ったメッセージを送信。',

        'build_system_title' => '自動ビルドシステム',
        'build_system_desc' => 'ワンクリックでアプリをビルド。分散ビルドシステムが配布可能なプラットフォーム固有のパッケージを自動生成。',

        'app_signing_title' => '安全なアプリ署名',
        'app_signing_desc' => '署名証明書を安全にアップロードして管理。アプリストア配布用のリリースビルドに自信を持って署名。',

        'version_management_title' => 'バージョン管理',
        'version_management_desc' => 'ビルド履歴で複数のアプリバージョンを管理。変更を追跡し、必要に応じてロールバックし、バージョン管理を簡単に維持。',

        'qr_testing_title' => 'QRコードテスト',
        'qr_testing_desc' => 'QRコードダウンロードでアプリを即座にテスト。アプリストアに公開する前に、テスターやクライアントとビルドを共有。',

        'build_tracking_title' => 'ビルド追跡',
        'build_tracking_desc' => '詳細なログでビルド状況をリアルタイムに監視。ビルド時間、エラーを追跡し、いつでも以前のバージョンをダウンロード可能。',

        'ai_assistant_title' => 'AI搭載アシスタント',
        'ai_assistant_desc' => 'アプリ設定のインテリジェントなサポートを受けられます。AIアシスタントがウェブサイトに基づいてナビゲーション、色、設定を自動的にセットアップ。',

        'api_access_title' => 'APIアクセス',
        'api_access_desc' => '包括的なAPIでワークフローと統合。アプリ作成、ビルドのトリガー、通知の管理をプログラムで自動化。',

        'hosted_pages_title' => 'ホステッドページ',
        'hosted_pages_desc' => 'カスタムHTMLページをアプリに直接埋め込み。完全なデザインコントロールで概要ページ、FAQ、利用規約などを作成。',
    ],

    // How It Works Section
    'how_it_works' => [
        'default_title' => '使い方',
        'default_subtitle' => '4つの簡単なステップでモバイルアプリを構築',

        'step1_title' => 'URLを入力',
        'step1_desc' => 'ウェブサイトのURLを貼り付けると、自動的に分析してすぐに始められます。',

        'step2_title' => 'デザインをカスタマイズ',
        'step2_desc' => '色、アイコン、スプラッシュスクリーン、ナビゲーションスタイルを選択。AIアシスタンスで素早くセットアップ。',

        'step3_title' => 'アプリをビルド',
        'step3_desc' => '分散システムでワンクリックビルド。数分でネイティブビルドを取得。',

        'step4_title' => 'ダウンロード＆公開',
        'step4_desc' => 'アプリをダウンロードするかQRコードをスキャンしてテスト。アプリストア公開の準備完了。',
    ],

    // Pricing Section
    'pricing' => [
        'default_title' => 'シンプルで透明な料金',
        'default_description' => 'ニーズに合った最適なプランを選択。すべてのプランにはコア機能が含まれ、ビルドクレジットの割り当てが異なります。',
        'default_popular_badge' => '人気',
        'default_free_text' => '無料',
        'default_no_plans' => '料金プランは近日公開予定です。後ほどご確認ください。',
        'start_free' => '無料で始める',
        'go_pro' => 'Proにアップグレード',
        'get_enterprise' => 'Enterpriseを取得',
    ],

    // Testimonials Section
    'testimonials' => [
        'default_title' => 'お客様の声',
        'default_subtitle' => '数千人の満足している開発者やビジネスに参加',
        'anonymous' => '匿名',
    ],

    // CTA Section
    'cta' => [
        'title' => '今日からアプリ構築を始めましょう',
        'subtitle' => ':site_nameでアプリを構築する数千人の開発者やビジネスに参加。クレジットカード不要。',
        'button' => '無料で始める',
    ],

    // Footer Section
    'footer' => [
        'tagline' => '数分でウェブサイトからネイティブアプリを構築。コーディング不要のプロフェッショナルなアプリビルダー。',
        'privacy_policy' => 'プライバシーポリシー',
        'terms_of_service' => '利用規約',
        'cookie_policy' => 'Cookieポリシー',
        'copyright' => '© :year. 著作権所有。',
    ],

    // Social Proof Section
    'social_proof' => [
        'happy_developers' => '満足している開発者',
        'apps_created' => '作成されたアプリ',
        'builds_generated' => '生成されたビルド',
    ],

    // Logos Section
    'logos' => [
        'title' => '多くの企業に選ばれています',
    ],

    // Page Titles
    'page_title' => '数分でネイティブモバイルアプリを作成',
];
