<?php

return [
    // Page Titles
    'admin_overview' => '관리자 개요',
    'overview_title' => '개요',
    'users_title' => '사용자',
    'subscriptions_title' => '구독',
    'transactions_title' => '거래',
    'plans_title' => '플랜',
    'builders_title' => '빌더',
    'plugins_title' => '플러그인',
    'languages_title' => '언어',
    'cronjobs_title' => '크론 작업',
    'email_templates_title' => '이메일 템플릿',
    'audit_logs_title' => '감사 로그',
    'settings_title' => '설정',

    // Page Subtitles
    'users_subtitle' => '플랫폼 사용자 및 계정 관리',
    'subscriptions_subtitle' => '사용자 구독 및 결제 모니터링',
    'transactions_subtitle' => '결제 거래 조회 및 관리',
    'plans_subtitle' => '구독 플랜 및 가격 설정',
    'builders_subtitle' => '앱 컴파일용 빌더 관리',
    'plugins_subtitle' => '설치된 플러그인 관리',
    'languages_subtitle' => '사용 가능한 언어 관리',
    'cronjobs_subtitle' => '예약된 작업 모니터링',
    'email_templates_subtitle' => '사용자에게 발송되는 이메일 알림 커스터마이징',
    'cronjobs_subtitle_full' => '예약된 작업 및 자동화 모니터링',
    'settings_subtitle_full' => '시스템 전반 설정 및 환경설정 구성',
    'search_settings' => '설정 검색...',
    'no_settings_found' => '일치하는 설정을 찾을 수 없습니다',
    'system_settings' => '시스템 설정',
    'clear_search' => '검색 지우기',

    // Settings Sidebar Navigation
    'settings_section_general' => '일반',
    'settings_section_plans' => '플랜',
    'settings_section_auth' => '인증',
    'settings_section_email' => '이메일',
    'settings_section_privacy' => '개인정보',
    'settings_section_preview' => '미리보기',
    'settings_section_ai' => 'AI 채팅',
    'settings_category_platform' => '플랫폼',
    'settings_category_security' => '보안',
    'settings_category_integrations' => '통합',
    'audit_logs_subtitle' => 'GDPR 준수를 위한 사용자 활동 및 시스템 이벤트 추적',
    'no_audit_logs_found' => '감사 로그를 찾을 수 없습니다.',
    'search_audit_logs' => '사용자, 활동, IP로 검색...',
    'date_time' => '날짜/시간',
    'actor' => '수행자',
    'ip_address' => 'IP 주소',
    'details' => '세부 정보',
    'view_details' => '세부 정보 보기',
    'system' => '시스템',
    'clear_filters' => '필터 지우기',
    'to' => '~',
    'settings_subtitle' => '시스템 설정 구성',

    // Users
    'add_user' => '사용자 추가',
    'edit_user' => '사용자 편집',
    'create_user' => '사용자 생성',
    'delete_user' => '사용자 삭제',
    'user_info' => '사용자 정보',
    'user_details' => '사용자 세부 정보',
    'no_users_found' => '사용자를 찾을 수 없습니다.',
    'search_users' => '사용자 검색...',
    'user_role' => '역할',
    'user_plan' => '플랜',
    'user_joined' => '가입일',
    'email_verified' => '이메일 인증됨',
    'mark_email_verified' => '이메일 인증됨으로 표시',
    'role_admin' => '관리자',
    'role_user' => '사용자',
    'leave_blank_password' => '현재 비밀번호를 유지하려면 비워두세요',

    // Plans
    'add_plan' => '플랜 추가',
    'edit_plan' => '플랜 편집',
    'create_plan' => '플랜 생성',
    'create_new_plan' => '새 플랜 생성',
    'update_plan' => '플랜 업데이트',
    'delete_plan' => '플랜 삭제',
    'no_plans_found' => '플랜을 찾을 수 없습니다.',
    'plan_features' => '기능',
    'plan_price' => '가격',
    'plan_interval' => '결제 주기',
    'monthly' => '월간',
    'yearly' => '연간',
    'default_plan' => '기본 플랜',
    'mark_as_default' => '기본 플랜으로 설정',
    'per_month' => '/월',
    'subscribers' => '구독자',
    'plan_name' => '플랜 이름',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => '기본 정보',
    'usage_limits' => '사용량 한도',
    'monthly_build_credits' => '월간 빌드 크레딧',
    'unlimited' => '무제한',
    'appetize_preview' => 'Appetize 미리보기',
    'hosted_pages' => '호스팅 페이지',
    'ai_assistant' => 'AI 어시스턴트',
    'allow_own_api_keys' => '자체 API 키 허용',
    'permissions' => '권한',
    'custom_css_js_injection' => '커스텀 CSS/JS 주입',
    'api_access' => 'API 액세스',
    'builder_access' => '빌더 액세스',
    'all_builders_allowed' => '모든 빌더 허용',
    'select_builders' => '빌더 선택',
    'builders_selected' => ':count개의 빌더 선택됨',
    'allow_all_builders' => '모든 빌더 허용',
    'search_builders_placeholder' => '빌더 검색...',
    'features_pricing_display' => '기능 (가격 표시용)',
    'feature_name' => '기능 이름',
    'included' => '포함',
    'not_included' => '미포함',
    'no_features_added' => '아직 기능이 추가되지 않았습니다. 가격 페이지에 표시할 기능을 추가하세요.',

    // Subscriptions
    'add_subscription' => '구독 추가',
    'subscription_details' => '구독 세부 정보',
    'no_subscriptions_found' => '구독을 찾을 수 없습니다.',
    'search_subscriptions' => '구독 검색...',
    'renewal_date' => '갱신일',
    'subscription_status' => '상태',
    'change_plan' => '플랜 변경',
    'cancel_subscription' => '구독 취소',
    'next_billing' => '다음 결제일',
    'no_plan' => '플랜 없음',
    'select_user' => '사용자 선택',
    'select_plan' => '플랜 선택',
    'payment_method_placeholder' => '수동, 은행 이체 등',

    // Transactions
    'transaction_details' => '거래 세부 정보',
    'no_transactions_found' => '거래를 찾을 수 없습니다.',
    'search_transactions' => '거래 검색...',
    'transaction_id' => 'ID',
    'transaction_date' => '날짜',
    'transaction_amount' => '금액',
    'payment_method' => '결제 수단',
    'payment_gateway' => '결제 게이트웨이',
    'transaction_status' => '상태',
    'approve' => '승인',
    'decline' => '거부',
    'confirm_approval' => '승인 확인',
    'confirm_decline' => '거부 확인',
    'approve_payment' => '결제 승인',
    'decline_payment' => '결제 거부',
    'approve_bank_transfer_confirm' => '이 은행 이체 결제를 승인하시겠습니까? 사용자의 구독이 활성화됩니다.',
    'decline_bank_transfer_confirm' => '이 은행 이체 결제를 거부하시겠습니까? 구독이 취소되고 사용자에게 알림이 발송됩니다.',

    // Builders
    'add_builder' => '빌더 추가',
    'edit_builder' => '빌더 편집',
    'create_builder' => '빌더 생성',
    'delete_builder' => '빌더 삭제',
    'no_builders_found' => '빌더를 찾을 수 없습니다.',
    'search_builders' => '빌더 검색...',
    'builder_name' => '빌더 이름',
    'builder_url' => 'URL',
    'builder_status' => '상태',
    'builder_platform' => '플랫폼',
    'builder_platforms' => '플랫폼',
    'builder_name_placeholder' => '프로덕션 빌더',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => '생성된 서버 키',
    'builder_queue' => '대기열',
    'current_builds' => '현재 빌드',
    'total_builds' => '전체 빌드',
    'server_url' => '서버 URL',
    'port' => '포트',
    'server_key' => '서버 키',
    'server_key_help' => '이 빌더에 대한 API 요청 인증에 사용됩니다',
    'generate' => '생성',
    'max_queue' => '최대 대기열',
    'max_queue_help' => '최대 동시 빌드 수',
    'build_credit_cost' => '빌드 크레딧 비용',
    'credit_cost_help' => '빌드당 차감되는 크레딧',
    'supported_platforms' => '지원 플랫폼',
    'select_platforms' => '플랫폼 선택',
    'platforms_selected' => ':count개의 플랫폼 선택됨',
    'platforms_help' => '이 빌더가 지원하는 플랫폼을 하나 이상 선택하세요',
    'no_platforms_available' => '사용 가능한 플랫폼이 없습니다',
    'no_builders_configured' => '아직 빌더가 설정되지 않았습니다.',
    'default' => '기본',
    'locked' => '잠김',
    'from_purchase_code' => '구매 코드에서',
    'purchase_code_not_set_warning' => '구매 코드가 설정되지 않았습니다',
    'purchase_code_not_set_description' => '기본 빌더에는 유효한 구매 코드가 필요합니다. 설정 > 일반에서 설정해 주세요.',
    'server_key_from_purchase_code_help' => '서버 키는 구매 코드에서 자동으로 설정됩니다.',

    // Plugins
    'upload_plugin' => '플러그인 업로드',
    'configure_plugin' => '설정',
    'delete_plugin' => '플러그인 삭제',
    'no_plugins_found' => '플러그인을 찾을 수 없습니다.',
    'plugin_name' => '이름',
    'plugin_version' => '버전',
    'plugin_type' => '유형',
    'plugin_status' => '상태',

    // Languages
    'add_language' => '언어 추가',
    'add_new_language' => '새 언어 추가',
    'edit_language' => '언어 편집',
    'create_language' => '언어 생성',
    'delete_language' => '언어 삭제',
    'no_languages_found' => '언어를 찾을 수 없습니다.',
    'cannot_delete_default_language' => '기본 언어 또는 주 언어는 삭제할 수 없습니다.',
    'default_language_badge' => '기본',
    'language_name' => '언어 이름',
    'language_code' => '언어 코드',
    'language_code_help' => '2자리 ISO 639-1 코드 (예: en, es, fr)',
    'language_code_from_folder' => '사용 가능한 번역 폴더에서 선택',
    'language_flag' => '깃발',
    'language_flag_help' => '국가 깃발 이모지',
    'language_flag_auto' => '깃발은 언어 코드에 따라 자동으로 설정됩니다',
    'language_flag_country_code_help' => '2자리 국가 코드 (예: us, gb, es)',
    'language_name_placeholder' => 'English',
    'language_code_placeholder' => 'en',
    'language_flag_placeholder' => '🇺🇸',
    'language_status' => '상태',
    'rtl_support' => '텍스트 방향',
    'rtl_enabled' => '오른쪽에서 왼쪽 (RTL)',
    'rtl_description' => '아랍어, 히브리어, 페르시아어, 우르두어와 같은 언어에 활성화하세요',
    'translation_files_created' => '번역 파일이 생성됩니다: lang/:code/',
    'translation_files_auto_created' => '이 언어를 추가하기 전에 :path에 번역 파일이 있는지 확인하세요. lang/en/ 폴더를 복사하고, 언어 코드로 이름을 변경한 후 내용을 번역하세요.',

    // Email Templates
    'edit_template' => '템플릿 편집',
    'edit_email_template' => '이메일 템플릿 편집',
    'reset_template' => '기본값으로 재설정',
    'no_templates_found' => '템플릿을 찾을 수 없습니다.',
    'template_subject' => '제목',
    'template_body' => '본문',
    'template_variables' => '사용 가능한 변수',
    'subject_line' => '제목줄',
    'email_subject_placeholder' => '이메일 제목...',
    'email_body' => '이메일 본문',
    'click_to_insert' => '커서 위치에 삽입하려면 클릭하세요',
    'no_variables_available' => '이 템플릿에 사용 가능한 변수가 없습니다.',
    'quick_tips' => '빠른 팁',
    'variables_replaced' => '변수는 발송 시 실제 데이터로 대체됩니다',
    'toolbar_format_tip' => '도구 모음을 사용하여 텍스트 서식, 링크 추가, 목록 생성을 하세요',
    'link_tip' => '텍스트를 선택하고 링크 버튼을 클릭하여 클릭 가능한 링크를 추가하세요',

    // Cronjobs
    'no_cronjobs_found' => '크론 작업을 찾을 수 없습니다.',
    'no_cron_logs_found' => '크론 로그를 찾을 수 없습니다.',
    'search_logs' => '로그 검색...',
    'job_name' => '작업명',
    'job' => '작업',
    'last_run' => '마지막 실행',
    'next_run' => '다음 실행',
    'run_duration' => '실행 시간',
    'started' => '시작됨',
    'duration' => '시간',
    'triggered_by' => '트리거',
    'message' => '메시지',
    'all_jobs' => '모든 작업',
    'trigger_manually' => '수동 트리거',
    'status_success' => '성공',
    'status_running' => '실행 중',

    // Settings
    'general_settings' => '일반 설정',
    'email_settings' => '이메일 설정',
    'social_login_settings' => '소셜 로그인',
    'appetize_settings' => 'Appetize 설정',
    'ai_settings' => 'AI 설정',
    'gdpr_settings' => 'GDPR 설정',

    // General Settings Fields
    'site_name' => '사이트 이름',
    'site_description' => '사이트 설명',
    'site_tagline' => '사이트 태그라인',
    'logo' => '로고',
    'logo_dark' => '다크 모드 로고',
    'favicon' => '파비콘',
    'default_theme' => '기본 테마',
    'landing_page_enabled' => '랜딩 페이지 활성화',
    'system_currency' => '시스템 통화',
    'default_language' => '기본 언어',
    'default_language_description' => '환경설정이 없는 신규 방문자 및 사용자를 위한 기본 언어',

    // Status Labels
    'status_active' => '활성',
    'status_inactive' => '비활성',
    'status_pending' => '대기 중',
    'status_expired' => '만료됨',
    'status_cancelled' => '취소됨',
    'status_completed' => '완료',
    'status_failed' => '실패',

    // Demo Mode
    'demo_mode_notice' => '데모 모드에서는 설정을 수정할 수 없습니다.',
    'disabled_in_demo' => '데모 모드에서 비활성화됨',
    'hidden_in_demo' => '데모 모드에서 숨겨짐',

    // Plugins
    'plugins_title_full' => '플러그인',
    'plugins_subtitle_full' => '커스텀 플러그인으로 기능 확장',
    'no_plugins_installed' => '설치된 플러그인 없음',
    'plugin_activate' => '활성화',
    'plugin_deactivate' => '비활성화',
    'plugin_uninstall' => '제거',
    'plugin_author' => ':author 제작',

    // Languages
    'languages_title_full' => '언어',
    'languages_subtitle_full' => '언어 번역 및 현지화 관리',

    // Cronjobs
    'cronjobs_title_full' => '크론 작업',
    'cronjobs_tab_jobs' => '예약된 작업',
    'cronjobs_tab_logs' => '실행 로그',
    'execute_job' => '실행',
    'executing_job' => '실행 중...',

    // Email Settings
    'email_config_title' => '이메일 설정',
    'email_config_subtitle' => '이메일 설정 및 SMTP 서버 구성',
    'mail_driver' => '메일 드라이버',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail은 서버의 내장 메일 설정을 사용합니다. 간단하지만 일부 서버에서 전송 문제가 발생할 수 있습니다.',
    'php_mail_warning' => '참고: 일부 호스팅 제공업체는 PHP mail() 함수를 비활성화합니다. 이메일이 발송되지 않으면 SMTP로 전환하는 것을 고려하세요.',
    'smtp_config' => 'SMTP 서버 설정',
    'smtp_host' => 'SMTP 호스트',
    'smtp_port' => 'SMTP 포트',
    'smtp_username' => 'SMTP 사용자명',
    'smtp_password' => 'SMTP 비밀번호',
    'smtp_encryption' => '암호화',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => '없음',
    'admin_notifications' => '관리자 알림',
    'admin_email' => '관리자 알림 이메일',
    'admin_email_help' => '관리자 알림을 수신할 이메일 주소. 비워두면 로그인한 관리자의 이메일이 사용됩니다.',
    'notify_user_registered' => '신규 사용자 등록',
    'notify_subscription_created' => '신규 구독 생성',
    'notify_subscription_cancelled' => '구독 취소',
    'notify_payment_received' => '결제 수신',
    'notify_payment_failed' => '결제 실패',
    'notify_build_started' => '빌드 시작',
    'notify_build_completed' => '빌드 완료',
    'notify_build_failed' => '빌드 실패',
    'test_email' => '테스트 이메일',
    'send_test_email' => '테스트 이메일 보내기',
    'sending' => '발송 중...',
    'mail_from_name' => '발신자 이름',
    'mail_from_address' => '발신자 주소',
    'php_mail_info' => 'PHP Mail은 서버의 내장 메일 설정(sendmail/postfix)을 사용합니다. 이 패널에서 추가 설정이 필요하지 않습니다.',
    'php_mail_switch_warning' => '참고: 일부 호스팅 제공업체는 PHP mail() 함수를 비활성화합니다. 이메일 발송이 실패하면 SMTP로 전환하세요.',
    'admin_notifications_subtitle' => '관리자 결제 알림이 발송될 위치 구성',
    'admin_email_description' => '관리자 알림을 수신할 이메일 주소. 테스트 이메일에도 사용됩니다.',
    'notification_events' => '알림 이벤트',
    'notification_events_description' => '관리자 알림을 트리거할 이벤트를 선택하세요',
    'event_subscription_activated' => '구독 활성화',
    'event_payment_completed' => '결제 완료',
    'event_payment_failed' => '결제 실패',
    'event_subscription_cancelled' => '구독 취소',
    'event_subscription_expired' => '구독 만료',
    'event_bank_transfer_pending' => '은행 이체 대기 중',
    'event_user_registered' => '사용자 등록',
    'event_build_completed' => '빌드 완료',
    'event_build_failed' => '빌드 실패',

    // Social Login Settings
    'auth_settings_title' => '인증 설정',
    'auth_settings_subtitle' => '회원가입 및 소셜 로그인 옵션 구성',
    'enable_registration' => '회원가입 활성화',
    'enable_registration_description' => '신규 사용자가 계정을 등록할 수 있도록 허용',
    'require_email_verification' => '이메일 인증 필요',
    'require_email_verification_description' => '비활성화 시 신규 가입은 자동으로 인증됩니다',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => '봇으로부터 인증 양식 보호',
    'recaptcha_site_key' => '사이트 키',
    'recaptcha_site_key_placeholder' => 'reCAPTCHA v3 사이트 키',
    'recaptcha_secret_key' => '시크릿 키',
    'recaptcha_secret_key_placeholder' => 'reCAPTCHA v3 시크릿 키',
    'leave_blank_keep_current' => '현재 값을 유지하려면 비워두세요',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => '클라이언트 ID',
    'client_id_placeholder' => ':provider 클라이언트 ID',
    'client_secret' => '클라이언트 시크릿',
    'client_secret_placeholder' => ':provider 클라이언트 시크릿',
    'app_id' => '앱 ID',
    'app_id_placeholder' => ':provider 앱 ID',
    'app_secret' => '앱 시크릿',
    'app_secret_placeholder' => ':provider 앱 시크릿',
    'callback_url' => '콜백 URL',
    'oauth_help' => ':provider 개발자 콘솔에서 OAuth 자격 증명을 생성하세요. 위의 콜백 URL을 사용하세요.',
    'test_connection' => '연결 테스트',
    'testing' => '테스트 중...',
    'configure_oauth' => ':provider OAuth 자격 증명 구성',
    'add_url_to_console' => '이 URL을 :provider에 추가하세요',
    'your_provider_key' => ':provider :type',
    'recaptcha_help' => ':link에서 키를 받으세요. reCAPTCHA v3를 선택해야 합니다.',
    'recaptcha_console' => 'Google reCAPTCHA 관리 콘솔',
    'get_api_key_from' => ':link에서 API 키를 받으세요',

    // General Settings
    'general_settings_title' => '일반 설정',
    'general_settings_subtitle' => '사이트 정보 및 브랜딩 업데이트',
    'site_name_label' => '사이트 이름',
    'site_description_label' => '사이트 설명',
    'site_description_placeholder' => '메타 설명 및 SEO에 사용됩니다',
    'site_tagline_label' => '사이트 태그라인',
    'site_tagline_placeholder' => '로고 아래에 표시되는 짧은 태그라인',
    'site_tagline_help' => '사이드바 및 로그인 페이지의 로고 아래에 표시됩니다',
    'purchase_code_label' => '구매 코드',
    'purchase_code_help' => '이 설치에 대한 라이선스 또는 구매 코드 (선택사항)',
    'logo_light' => '로고 (라이트 모드)',
    'logo_dark_label' => '로고 (다크 모드)',
    'delete_logo' => '로고 삭제',
    'delete_dark_logo' => '다크 로고 삭제',
    'delete_favicon' => '파비콘 삭제',
    'logo_help' => '권장: 200x50px (가로) 또는 50x50px (정사각형). 투명 배경의 PNG, JPG, SVG. 최대 2MB.',
    'favicon_label' => '파비콘',
    'favicon_help' => '권장: 32x32px 또는 16x16px. PNG, ICO 또는 SVG. 최대 1MB.',
    'default_theme_label' => '기본 색상 테마',
    'theme_system' => '시스템 (사용자 기기 설정 따름)',
    'theme_light' => '라이트',
    'theme_dark' => '다크',
    'theme_help' => '신규 방문자를 위한 기본 테마. 사용자는 설정에서 변경할 수 있습니다.',
    'currency_label' => '시스템 통화',
    'currency_help' => '모든 가격 및 결제에 사용되는 통화. 이에 따라 사용 가능한 결제 게이트웨이가 결정됩니다.',
    'landing_page_toggle' => '공개 랜딩 페이지 활성화',
    'landing_page_help' => '비활성화 시 루트 URL(/)에 접근하는 방문자는 로그인 페이지로 리디렉션됩니다',

    // Plan Configuration Settings
    'plan_config_title' => '플랜 설정',
    'plan_config_subtitle' => '신규 사용자를 위한 기본 플랜 설정 구성',
    'default_plan_label' => '기본 플랜',
    'default_plan_none' => '없음 (구독 필요)',
    'default_plan_help' => '가입 시 신규 사용자에게 할당되는 플랜. 플랜을 선택하지 않으면 사용자는 기능에 액세스하려면 구독해야 합니다.',

    // AI Settings
    'ai_settings_title' => 'AI 채팅 어시스턴트',
    'ai_settings_subtitle' => 'AI 기반 앱 생성 어시스턴트 구성',
    'enable_ai' => 'AI 채팅 어시스턴트 활성화',
    'enable_ai_description' => '사용자가 AI 대화를 통해 앱을 생성하고 설정할 수 있도록 허용',
    'enable_streaming' => '스트리밍 응답 활성화',
    'enable_streaming_description' => '더 인터랙티브한 경험을 위해 AI 응답을 단어별로 스트리밍합니다',
    'streaming_warning' => '일부 공유 호스팅 환경에서는 작동하지 않을 수 있습니다',
    'ai_provider' => 'AI 제공자',
    'ai_provider_help' => 'OpenAI (GPT-4.1) 또는 Anthropic (Claude) 중에서 선택하세요',
    'api_key' => 'API 키',
    'enter_api_key' => 'API 키를 입력하세요',
    'openai_console' => 'OpenAI 콘솔',
    'anthropic_console' => 'Anthropic 콘솔',
    'api_key_help' => ':provider에서 API 키를 받으세요',
    'advanced_settings' => '고급 설정',
    'ai_model' => 'AI 모델',
    'ai_model_help' => '채팅 응답에 사용할 AI 모델을 선택하세요',
    'temperature' => '온도',
    'temperature_help' => '무작위성을 제어합니다. 낮을수록 집중적, 높을수록 창의적',
    'max_tokens' => '최대 응답 토큰',
    'max_tokens_help' => 'AI 응답당 최대 토큰. 높을수록 긴 응답이지만 비용 증가',
    'auto_summarization' => '자동 요약',
    'enable_summarization' => '자동 요약 활성화',
    'summarization_help' => '긴 대화에서 토큰 사용량을 줄이기 위해 오래된 메시지를 자동으로 요약합니다',
    'summarization_threshold' => '요약 임계값',
    'summarization_threshold_help' => '자동 요약이 트리거되기 전 메시지 수',
    'summarization_keep_recent' => '최근 메시지 유지',
    'summarization_keep_recent_help' => '유지할 최근 메시지 수',
    'summarization_max_length' => '최대 요약 길이',
    'summarization_max_length_help' => '요약의 최대 문자 수',
    'chat_widget' => '채팅 위젯',
    'widget_position' => '위젯 위치',
    'position_bottom_right' => '오른쪽 하단',
    'position_bottom_left' => '왼쪽 하단',
    'position_top_right' => '오른쪽 상단',
    'position_top_left' => '왼쪽 상단',
    'position_help' => '앱 편집기 페이지에서 AI 채팅 위젯이 표시되는 위치',

    // GDPR Settings
    'gdpr_settings_title' => 'GDPR 설정',
    'gdpr_settings_subtitle' => 'GDPR 준수 및 개인정보 설정 구성',
    'enable_cookie_consent' => '쿠키 동의 배너 활성화',
    'enable_data_export' => '데이터 내보내기 활성화',
    'enable_account_deletion' => '계정 삭제 활성화',
    'deletion_grace_period' => '계정 삭제 유예 기간 (일)',
    'audit_log_retention' => '감사 로그 보관 기간 (일)',

    // Appetize Settings
    'appetize_settings_title' => 'Appetize 설정',
    'appetize_settings_subtitle' => '라이브 앱 미리보기를 위한 Appetize.io 구성',
    'appetize_api_token' => 'Appetize API 토큰',
    'appetize_api_token_help' => 'Appetize.io 대시보드에서 API 토큰을 받으세요',

    // Delete/Action Modal Messages
    'delete_user_confirm' => '정말 삭제하시겠습니까',
    'delete_builder_confirm' => '정말 삭제하시겠습니까',
    'delete_plan_confirm' => '정말 삭제하시겠습니까',
    'delete_plan_confirm_suffix' => '플랜을?',
    'delete_language_confirm' => '정말 삭제하시겠습니까',
    'delete_language_note' => '이 작업은 되돌릴 수 없습니다. 데이터 안전을 위해 번역 파일은 유지됩니다.',
    'uninstall_plugin' => '플러그인 제거',
    'uninstall_plugin_confirm' => '정말 제거하시겠습니까',
    'cancel_subscription_confirm' => '정말 구독을 취소하시겠습니까',
    'reset_email_template' => '이메일 템플릿 재설정',
    'reset_template_confirm' => '정말 재설정하시겠습니까',
    'reset_template_confirm_suffix' => '을(를) 기본 내용으로?',
    'reset_template_warning' => '사용자 정의한 내용이 모두 손실됩니다.',
    'disabled_in_demo' => '데모 모드에서 비활성화됨',

    // Plugin Upload Modal
    'plugin_file' => '플러그인 파일',
    'plugin_file_help' => 'ZIP 파일 (최대 10MB)',
    'installing_plugin' => '플러그인 설치 중...',
    'installing' => '설치 중...',

    // Plugin Config Modal
    'configure_plugin_title' => ':name 설정',
    'no_config_required' => '설정 필요 없음',
    'no_config_required_desc' => '이 플러그인은 설정이 필요하지 않습니다.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Appetize.io 통합',
    'appetize_integration_subtitle' => '라이브 앱 미리보기 기능 구성',
    'enable_appetize_integration' => 'Appetize.io 통합 활성화',
    'enable_appetize_description' => 'Pro/Enterprise 플랜 사용자가 브라우저에서 앱을 미리 볼 수 있도록 허용',
    'appetize_api_token_placeholder' => 'Appetize.io API 토큰을 입력하세요',
    'appetize_api_token_link' => '다음에서 API 토큰을 받으세요',
    'auto_upload_builds' => 'Appetize에 빌드 자동 업로드',
    'auto_upload_description' => '성공한 빌드를 즉시 미리보기를 위해 자동으로 업로드',
    'preview_retention_days' => '미리보기 보관 기간 (일)',
    'preview_retention_help' => '비용 절감을 위해 이 기간 후 오래된 미리보기를 삭제합니다 (1-30일)',
    'session_timeout_seconds' => '세션 타임아웃 (초)',
    'session_timeout_help' => '비활성 후 세션이 종료되기까지의 타임아웃',
    'seconds_30' => '30초',
    'minute_1' => '1분',
    'minutes_2' => '2분',
    'minutes_3' => '3분',
    'minutes_5' => '5분',
    'minutes_10' => '10분',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'GDPR 및 개인정보 설정',
    'gdpr_privacy_settings_subtitle' => '데이터 보호 및 개인정보 준수 구성',
    'feature_toggles' => '기능 토글',
    'cookie_consent_banner' => '쿠키 동의 배너',
    'cookie_consent_description' => '신규 방문자에게 쿠키 동의 배너 표시',
    'user_data_export' => '사용자 데이터 내보내기',
    'user_data_export_description' => '사용자가 자신의 데이터 사본을 요청할 수 있도록 허용',
    'user_account_deletion' => '사용자 계정 삭제',
    'user_account_deletion_description' => '사용자가 계정 삭제를 요청할 수 있도록 허용',
    'policy_versions' => '정책 버전',
    'policy_versions_help' => '정책 버전을 업데이트하면 사용자에게 재동의가 요청됩니다.',
    'privacy_policy' => '개인정보 처리방침',
    'terms_of_service' => '이용약관',
    'cookie_policy' => '쿠키 정책',
    'data_retention_periods' => '데이터 보관 기간 (일)',
    'retention_transactions' => '거래',
    'retention_transactions_help' => '최소 365일 (법적 요구사항)',
    'retention_inactive_accounts' => '비활성 계정',
    'retention_expired_builds' => '만료된 빌드',
    'retention_audit_logs' => '감사 로그',
    'retention_data_exports' => '데이터 내보내기',
    'grace_periods_rate_limits' => '유예 기간 및 속도 제한',
    'account_deletion_grace_period' => '계정 삭제 유예 기간 (일)',
    'account_deletion_grace_help' => '계정이 영구적으로 삭제되기까지의 시간',
    'data_export_rate_limit' => '데이터 내보내기 속도 제한 (시간)',
    'data_export_rate_limit_help' => '내보내기 요청 사이의 최소 시간',

    // App/Plan Settings
    'plan_configuration' => '플랜 설정',
    'plan_configuration_subtitle' => '신규 사용자를 위한 기본 플랜 설정 구성',
    'default_plan_option_none' => '없음 (구독 필요)',
    'default_plan_description' => '신규 사용자에게 할당되는 플랜. 사용 전 구독이 필요하면 "없음"을 선택하세요.',

    // Overview Stats
    'overview_subtitle' => '시스템 전반 통계 및 관리 메트릭',
    'date_range_today' => '오늘',
    'date_range_week' => '주간',
    'date_range_month' => '월간',
    'date_range_year' => '연간',
    'date_range_all' => '전체',
    'auto_refresh' => '자동 새로고침',
    'total_system_users' => '전체 시스템 사용자',
    'active_subscriptions' => '활성 구독',
    'revenue_label' => ':period 수익',
    'total_apps' => '전체 앱',
    'vs_last_month' => '전월 대비',
    'total_builds_stat' => '전체 빌드',
    'completed_today' => '오늘 완료',
    'build_success_rate' => '빌드 성공률',
    'pending_queue' => '대기열',
    'total_transactions' => '전체 거래',
    'active_plans' => '활성 플랜',
    'active_builders' => '활성 빌더',
    'revenue_trends' => '수익 추이 (12개월)',
    'build_activity' => '빌드 활동 (최근 30일)',
    'revenue_by_gateway' => '결제 게이트웨이별 수익',
    'no_revenue_data' => '아직 수익 데이터가 없습니다',
    'total_revenue' => '총 수익',
    'platform_distribution' => '플랫폼 분포',
    'no_apps_created' => '아직 생성된 앱이 없습니다',
    'pending_payments' => '대기 중인 결제',
    'active_users_7d' => '활성 사용자 (7일)',
    'notifications_today' => '오늘 알림',
    'build_performance_by_platform' => '플랫폼별 빌드 성능',
    'platform' => '플랫폼',
    'completed' => '완료',
    'failed' => '실패',
    'success_rate' => '성공률',
    'avg_duration' => '평균 시간',
    'revenue_label_short' => '수익',
    'builds_label' => '빌드',
    'recent_user_registrations' => '최근 사용자 등록',
    'no_users_yet' => '아직 사용자가 없습니다',
    'recent_builds' => '최근 빌드',
    'no_builds_yet' => '아직 빌드가 없습니다',
    'recent_transactions' => '최근 거래',
    'no_transactions_yet' => '아직 거래가 없습니다',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => '작업',
    'cronjobs_tab_execution_logs' => '실행 로그',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'API 자격 증명',
        'webhook_configuration' => '웹훅 설정',
        'webhook_url' => '웹훅 URL',
        'copy' => '복사',
        'copied' => '복사됨!',
        'copy_failed' => '복사 실패. URL을 수동으로 선택하여 복사해 주세요.',
        'required_webhook_events' => '필수 웹훅 이벤트',
        'features' => '기능',
        'supported_features' => '지원 기능',
        'secret_key' => '시크릿 키',
        'webhook_secret' => '웹훅 시크릿',
        'webhook_signing_secret' => '웹훅 서명 시크릿',
        'optional' => '선택사항',

        // SSL Warning
        'ssl_warning' => '경고:',
        'ssl_warning_stripe' => '사이트가 HTTPS를 사용하지 않습니다. Stripe는 웹훅 및 프로덕션 사용에 HTTPS가 필요합니다.',
        'ssl_warning_paypal' => '사이트가 HTTPS를 사용하지 않습니다. PayPal 웹훅에는 보안 HTTPS 연결이 필요합니다. 운영 전에 SSL/TLS를 활성화하세요.',
        'ssl_warning_paystack' => '사이트가 HTTPS를 사용하지 않습니다. Paystack 웹훅에는 보안 HTTPS 연결이 필요합니다. 운영 전에 SSL/TLS를 활성화하세요.',

        // Stripe
        'stripe' => [
            'get_started' => 'Stripe 시작하기',
            'get_api_keys' => '다음에서 API 키를 받으세요',
            'dashboard_link' => 'Stripe 대시보드 → Developers → API Keys',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => '테스트용은 테스트 키(sk_test_), 프로덕션용은 라이브 키(sk_live_) 사용',
            'webhook_url_help' => 'Stripe 대시보드 → Developers → Webhooks에 이 URL을 추가하세요',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Stripe 대시보드에서 웹훅 엔드포인트 생성 후 받을 수 있습니다',
            'events_help' => '웹훅 엔드포인트 생성 시 다음 이벤트를 선택하세요:',
            'feature_currencies' => '전 세계 135개 이상의 통화 지원',
            'feature_intervals' => '모든 결제 주기 지원',
            'feature_renewal' => '자동 구독 갱신',
            'feature_customer_management' => '고객 관리',
            'feature_signature_verification' => '웹훅 서명 검증',
            'feature_refund' => '환불 처리',
            'feature_sca' => 'SCA(강력한 고객 인증) 준수',
        ],

        // PayPal
        'paypal' => [
            'client_id' => '클라이언트 ID',
            'client_id_help' => 'PayPal 개발자 대시보드에서 받으세요',
            'client_secret' => '클라이언트 시크릿',
            'client_secret_help' => '이 시크릿을 안전하게 보관하고 공개하지 마세요',
            'sandbox_mode' => '샌드박스 모드',
            'sandbox_mode_help' => 'PayPal 샌드박스로 테스트하려면 활성화하세요. 실제 거래 시 비활성화.',
            'webhook_url_help' => 'PayPal 웹훅 설정에 이 URL을 추가하세요',
            'webhook_id' => '웹훅 ID',
            'webhook_id_help' => '서명 검증을 위한 PayPal 대시보드의 웹훅 ID (보안을 위해 필요)',
            'events_help' => 'PayPal 웹훅 설정에서 다음 이벤트를 활성화하세요:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Razorpay 시작하기',
            'get_api_keys' => '다음에서 API 키를 받으세요',
            'dashboard_link' => 'Razorpay 대시보드 → Settings → API Keys',
            'key_id' => '키 ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => '테스트용은 테스트 키(rzp_test_), 프로덕션용은 라이브 키(rzp_live_) 사용',
            'key_secret' => '키 시크릿',
            'key_secret_help' => '이 시크릿을 안전하게 보관하고 공개하지 마세요',
            'webhook_url_help' => 'Razorpay 대시보드 → Settings → Webhooks에 이 URL을 추가하세요',
            'webhook_secret_placeholder' => '웹훅 시크릿 입력',
            'webhook_secret_help' => '웹훅 생성 후 Razorpay 대시보드에서 받으세요',
            'events_help' => 'Razorpay 대시보드 → Settings → Webhooks에서 다음 이벤트를 활성화하세요:',
            'feature_currencies' => '100개 이상의 통화 지원',
            'feature_intervals' => '모든 결제 주기 (일간, 주간, 월간, 연간)',
            'feature_payment_methods' => 'UPI, 카드, 넷뱅킹, 월렛, EMI',
            'feature_renewal' => '자동 구독 갱신',
            'feature_signature_verification' => '웹훅 서명 검증',
            'feature_refund' => '환불 처리',
            'feature_decimal' => '3자리 소수점 통화 지원 (KWD, BHD 등)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Paystack 시작하기',
            'get_api_keys' => '다음에서 API 키를 받으세요',
            'dashboard_link' => 'Paystack 대시보드 → Settings → API Keys & Webhooks',
            'secret_key_help' => 'Paystack 대시보드에서 받으세요 (테스트용은 테스트 키, 프로덕션용은 라이브 키 사용)',
            'webhook_url_help' => 'Paystack 웹훅 설정에 이 URL을 추가하세요',
            'webhook_secret_help' => '선택사항: 웹훅 서명 검증용 (프로덕션에 권장)',
            'webhook_secret_placeholder' => '서명 검증을 건너뛰려면 비워두세요',
            'events_help' => 'Paystack 대시보드 → Settings → API Keys & Webhooks에서 다음 이벤트를 활성화하세요:',
            'feature_currencies' => '통화: NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => '주기: 일간, 주간, 월간 (1, 3, 6개월), 연간',
            'feature_renewal' => '자동 구독 갱신',
            'feature_signature_verification' => '웹훅 서명 검증',
            'feature_interval_limitation' => '제한된 주기 지원 (문서 참조)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Crypto.com Pay 시작하기',
            'get_api_keys' => '다음에서 API 자격 증명을 받으세요',
            'dashboard_link' => 'Crypto.com Pay 대시보드',
            'monthly_only_title' => '월간 주기만 지원',
            'monthly_only_description' => 'Crypto.com Pay는 현재 월간 결제 주기만 지원합니다. 일간, 주간, 연간 구독은 지원되지 않습니다.',
            'secret_key_placeholder' => 'Crypto.com Pay 시크릿 키를 입력하세요',
            'secret_key_help' => 'Crypto.com Pay 대시보드에서 받으세요',
            'webhook_url_help' => 'Crypto.com Pay 웹훅 설정에 이 URL을 추가하세요',
            'webhook_secret_placeholder' => '웹훅 서명 시크릿 입력',
            'webhook_secret_help' => '웹훅 서명 검증에 필요',
            'events_help' => 'Crypto.com Pay 대시보드에서 다음 이벤트를 활성화하세요:',
            'feature_crypto_fiat' => '암호화폐 및 법정화폐 결제 수락',
            'feature_currencies' => '30개 이상의 지원 통화',
            'feature_renewal' => '자동 구독 갱신',
            'feature_signature_verification' => 'HMAC SHA-256 웹훅 서명 검증',
            'feature_monthly_only' => '월간 주기만 지원 (일간/주간/연간 미지원)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => '수동 승인 필요',
            'manual_approval_description' => '은행 이체 결제는 수동 확인이 필요합니다. 사용자는 결제 시작 후 아래 안내를 보게 됩니다. 관리자는 다음에서 결제를 승인하거나 거부해야 합니다',
            'transactions_link' => '거래',
            'instructions_title' => '은행 이체 안내',
            'instructions_label' => '사용자를 위한 안내',
            'instructions_placeholder' => "여기에 은행 계좌 정보와 이체 안내를 입력하세요...\n\n예시:\n\n은행명: ABC 은행\n예금주: 귀하의 회사명\n계좌번호: 123456789\nSwift 코드: ABCDEFGH\n참조: [사용자에게 구독 ID가 표시됩니다]\n\n결제 참조에 구독 ID를 포함하고 결제 증빙을 billing@yourcompany.com으로 보내주세요",
            'instructions_help' => '이 안내는 사용자가 플랜을 선택한 후 표시됩니다. 은행 계좌 정보, 참조 형식, 확인 단계를 포함하세요.',
            'workflow_title' => '은행 이체 결제 작동 방식:',
            'workflow_step_1' => '사용자가 플랜을 선택하고 은행 이체를 결제 수단으로 선택',
            'workflow_step_2' => '대기 중인 구독 및 거래가 생성됨',
            'workflow_step_3' => '사용자에게 위에서 구성한 안내가 표시됨',
            'workflow_step_4' => '사용자가 수동으로 은행 이체를 완료',
            'workflow_step_5' => '관리자가 대기 중인 결제 알림을 수신',
            'workflow_step_6' => '관리자가 결제 승인 → 구독 활성화 및 크레딧 충전',
            'workflow_step_7' => '관리자가 결제 거부 → 구독 및 거래 제거',
            'feature_currencies' => '모든 통화 지원',
            'feature_intervals' => '모든 결제 주기 지원 (일간, 주간, 월간, 연간)',
            'feature_simple_setup' => '간단한 설정 - API 자격 증명 불필요',
            'feature_manual_verification' => '보안을 위한 수동 검증',
            'feature_no_fees' => '거래 수수료 또는 타사 의존성 없음',
            'feature_admin_approval' => '각 결제에 관리자 승인 필요',
            'feature_no_renewal' => '자동 구독 갱신 없음',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => '무제한 빌드 크레딧',
    'feature_build_credits' => ':count 빌드 크레딧',
    'feature_all_builders' => '모든 활성 빌더 액세스',
    'feature_builder_access' => '빌더 액세스',
    'feature_single_builder' => '단일 빌더 액세스',
    'feature_multiple_builders' => ':count개의 빌더 액세스',
    'feature_custom_code' => '커스텀 CSS/JS 주입',
    'feature_api_access' => 'API 액세스',
    'feature_unlimited_hosted_pages' => '무제한 호스팅 페이지',
    'feature_hosted_pages' => '앱당 :count개의 호스팅 페이지',
    'feature_hosted_pages_disabled' => '호스팅 페이지',
    'feature_unlimited_ai_chat' => '무제한 AI 채팅',
    'feature_ai_tokens' => '월 :count AI 토큰',
    'feature_own_ai_key' => '자체 AI API 키 사용',
    'feature_ai_chat' => 'AI 채팅 어시스턴트',

    // Impersonation
    'impersonate' => '대리 로그인',
    'impersonate_user' => '사용자로 대리 로그인',
    'impersonation_started' => ':name으로 대리 로그인 중',
    'impersonation_stopped' => '대리 로그인이 종료되었습니다. 돌아오신 것을 환영합니다!',
    'impersonating_as' => ':name으로 보기',
    'exit_impersonation' => '종료',
    'return_to_admin' => '관리자로 돌아가기',
    'not_impersonating' => '현재 어떤 사용자도 대리 로그인하고 있지 않습니다.',
    'admin_blocked_during_impersonation' => '대리 로그인 중에는 관리자 영역이 차단됩니다. 먼저 대리 로그인을 종료하세요.',
    'impersonation_disabled_demo' => '데모 모드에서는 대리 로그인이 비활성화되어 있습니다.',
    'only_admins_can_impersonate' => '관리자만 사용자로 대리 로그인할 수 있습니다.',
];
