<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => 'Thông tin cơ bản',
        'basic_information_description' => 'Chi tiết thiết yếu về ứng dụng của bạn',
        'app_name' => 'Tên ứng dụng',
        'app_name_placeholder' => 'Ứng dụng tuyệt vời của tôi',
        'app_name_help' => 'Hiển thị trên màn hình chính thiết bị',
        'website_url' => 'URL Website',
        'website_url_placeholder' => 'https://example.com',
        'website_url_help' => 'URL đầy đủ của website hoặc web app của bạn',
        'configuration' => 'Cấu hình',
        'configuration_description' => 'Cài đặt kỹ thuật và định danh',
        'app_id' => 'APP ID',
        'app_id_tooltip' => 'Định danh gói duy nhất được sử dụng bởi cửa hàng ứng dụng',
        'app_id_placeholder' => 'com.example.app',
        'app_id_help' => 'App ID không thể thay đổi sau khi tạo',
        'copy' => 'Sao chép',
        'copied' => 'Đã sao chép!',
        'screen_orientation' => 'Hướng màn hình',
        'screen_orientation_help' => 'Kiểm soát cách ứng dụng xoay trên thiết bị',
        'orientation_system' => 'Hệ thống',
        'orientation_portrait' => 'Dọc',
        'orientation_landscape' => 'Ngang',
        'app_language' => 'Ngôn ngữ ứng dụng (mã ISO)',
        'app_language_help' => 'Ngôn ngữ chính cho nội dung ứng dụng của bạn',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'Mẫu bố cục',
        'layout_template_description' => 'Chọn cấu trúc điều hướng cho ứng dụng của bạn',
        'layout_app_bar_drawer' => 'Thanh ứng dụng + Ngăn kéo',
        'layout_app_bar_tabs' => 'Thanh ứng dụng + Tab điều hướng',
        'layout_app_bar' => 'Thanh ứng dụng',
        'layout_blank' => 'Trống',
        'progress_indicator' => 'Chỉ báo tiến trình',
        'progress_indicator_help' => 'Kiểu chỉ báo tải hiển thị khi trang đang tải',
        'progress_disable' => 'Tắt',
        'progress_linear' => 'Tuyến tính',
        'progress_circular' => 'Tròn',
        'progress_indicator_color' => 'Màu chỉ báo tiến trình',
        'progress_indicator_color_help' => 'Màu của chỉ báo tiến trình tải',
        'show_app_bar_title' => 'Hiển thị tiêu đề trang web hiện tại trên thanh ứng dụng',
        'show_app_bar_title_help' => 'Hiển thị tiêu đề trang hiện tại trên thanh trên cùng',
        'nav_tab_icon_colors' => 'Màu biểu tượng tab điều hướng',
        'nav_tab_icon_colors_help' => 'Màu biểu tượng tab không hoạt động ở chế độ sáng và tối',
        'active_tab_colors' => 'Màu tab đang hoạt động',
        'active_tab_colors_help' => 'Màu của tab được chọn ở chế độ sáng và tối',
        'light_mode' => 'Chế độ sáng',
        'dark_mode' => 'Chế độ tối',
        'theme_colors' => 'Màu chủ đề',
        'theme_colors_description' => 'Màu chính xác định giao diện ứng dụng của bạn',
        'theme_color' => 'Màu chủ đề',
        'theme_color_help' => 'Màu chính được sử dụng xuyên suốt ứng dụng',
        'enable_dynamic_colors' => 'Bật Màu động Material You (Android 12+)',
        'enable_dynamic_colors_help' => 'Khi bật, ứng dụng sẽ điều chỉnh màu từ hình nền người dùng trên thiết bị Android 12+. Điều này ghi đè màu chủ đề ở trên.',
        'text_color_light' => 'Màu văn bản (Chế độ sáng)',
        'text_color_light_help' => 'Màu văn bản và biểu tượng mặc định ở chế độ sáng',
        'text_color_dark' => 'Màu văn bản (Chế độ tối)',
        'text_color_dark_help' => 'Màu văn bản và biểu tượng mặc định ở chế độ tối',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'Biểu tượng ứng dụng',
        'app_icon_description' => 'Tải lên biểu tượng ứng dụng dưới dạng tệp ZIP từ icon.kitchen',
        'current_icon' => 'Biểu tượng hiện tại',
        'icon_zip_uploaded' => 'ZIP biểu tượng đã tải lên',
        'icon_zip_uploaded_description' => 'Biểu tượng đã giải nén có sẵn cho nền tảng Android và Web',
        'default_icon' => 'Biểu tượng mặc định',
        'default_icon_description' => 'Tải lên biểu tượng tùy chỉnh để thay thế mặc định',
        'delete' => 'Xóa',
        'upload_zip_file' => 'Tải lên tệp ZIP',
        'upload_zip_help' => 'Tệp ZIP từ icon.kitchen (TỐI ĐA 10MB)',
        'how_to_create' => 'Cách tạo biểu tượng:',
        'step_visit' => 'Truy cập',
        'step_design' => 'Thiết kế biểu tượng ứng dụng',
        'step_download' => 'Tải xuống tệp ZIP chứa tất cả biểu tượng nền tảng',
        'step_upload' => 'Tải lên tệp ZIP tại đây',
        'zip_file_info' => 'Tệp ZIP phải chứa biểu tượng cho nền tảng Android và Web (Tối đa 10MB)',
        'upload_icon' => 'Tải lên biểu tượng',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'Giao diện màn hình khởi động',
        'appearance_description' => 'Tùy chỉnh nền, thời lượng hiển thị và hiệu ứng hoạt ảnh',
        'background_type' => 'Loại nền',
        'background_type_color' => 'Màu đơn sắc',
        'background_type_image' => 'Hình nền',
        'background_color' => 'Màu nền',
        'background_image' => 'Hình nền',
        'background_image_help' => 'Chỉ PNG (TỐI ĐA 2MB)',
        'delete_background_image' => 'Xóa hình nền',
        'display_duration' => 'Thời lượng hiển thị:',
        'seconds' => 'giây',
        'animation_effect' => 'Hiệu ứng hoạt ảnh',
        'animation_fade' => 'Mờ dần',
        'animation_slide' => 'Trượt',
        'animation_zoom' => 'Phóng to',
        'animation_none' => 'Không',
        'branding' => 'Thương hiệu màn hình khởi động',
        'branding_description' => 'Thêm logo, tiêu đề, phụ đề và kiểu văn bản cho màn hình khởi động',
        'show_logo' => 'Hiển thị Logo trên màn hình khởi động',
        'logo_image' => 'Hình ảnh Logo',
        'logo_image_help' => 'Khuyến nghị PNG trong suốt (TỐI ĐA 2MB)',
        'delete_logo' => 'Xóa Logo',
        'logo_size' => 'Kích thước Logo:',
        'logo_size_small' => 'Nhỏ (60dp)',
        'logo_size_medium' => 'Trung bình (150dp)',
        'logo_size_large' => 'Lớn (240dp)',
        'logo_size_help' => 'Điều chỉnh kích thước logo để hiển thị tối ưu',
        'title' => 'Tiêu đề',
        'title_placeholder' => 'Ứng dụng tuyệt vời của tôi',
        'subtitle' => 'Phụ đề',
        'subtitle_placeholder' => 'Chào mừng đến với ứng dụng tốt nhất',
        'text_theme' => 'Chủ đề văn bản',
        'text_theme_light' => 'Sáng (Văn bản trắng)',
        'text_theme_dark' => 'Tối (Văn bản đen)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'Giao diện ngăn kéo',
        'appearance_description' => 'Tùy chỉnh nền và kiểu trực quan của ngăn kéo điều hướng',
        'drawer_mode' => 'Chế độ ngăn kéo',
        'drawer_mode_help' => 'Chọn cách nền ngăn kéo hiển thị',
        'mode_default' => 'Mặc định (Màu chủ đề)',
        'mode_color' => 'Màu tùy chỉnh',
        'mode_image' => 'Hình nền',
        'background_color' => 'Màu nền',
        'background_color_help' => 'Màu nền tùy chỉnh cho ngăn kéo',
        'background_image' => 'Hình nền',
        'background_image_help' => 'Chỉ PNG (TỐI ĐA 2MB). Khuyến nghị: 1080x1920px',
        'delete_background_image' => 'Xóa hình nền',
        'branding' => 'Thương hiệu ngăn kéo',
        'branding_description' => 'Thêm logo, tiêu đề và tùy chỉnh giao diện văn bản trong tiêu đề ngăn kéo',
        'show_logo' => 'Hiển thị Logo trong ngăn kéo',
        'show_logo_help' => 'Hiển thị logo trong tiêu đề ngăn kéo',
        'logo_light' => 'Logo ngăn kéo (Chế độ sáng)',
        'logo_light_help' => 'Yêu cầu PNG trong suốt (TỐI ĐA 2MB) - Hiển thị khi ứng dụng ở chủ đề sáng',
        'delete_light_logo' => 'Xóa Logo sáng',
        'logo_dark' => 'Logo ngăn kéo (Chế độ tối)',
        'logo_dark_help' => 'Yêu cầu PNG trong suốt (TỐI ĐA 2MB) - Hiển thị khi ứng dụng ở chủ đề tối',
        'delete_dark_logo' => 'Xóa Logo tối',
        'logo_size' => 'Kích thước Logo:',
        'logo_size_small' => 'Nhỏ (40dp)',
        'logo_size_medium' => 'Trung bình (120dp)',
        'logo_size_large' => 'Lớn (200dp)',
        'logo_size_help' => 'Điều chỉnh kích thước logo để hiển thị tối ưu',
        'drawer_title' => 'Tiêu đề ngăn kéo',
        'drawer_title_placeholder' => 'Ứng dụng của tôi',
        'drawer_title_help' => 'Tiêu đề hiển thị trong tiêu đề ngăn kéo',
        'drawer_subtitle' => 'Phụ đề ngăn kéo',
        'drawer_subtitle_placeholder' => 'Chào mừng đến ứng dụng của tôi',
        'drawer_subtitle_help' => 'Phụ đề hoặc khẩu hiệu hiển thị bên dưới tiêu đề',
        'text_theme' => 'Chủ đề văn bản',
        'text_theme_help' => 'Màu văn bản cho tiêu đề ngăn kéo và mục menu',
        'text_theme_light' => 'Sáng (Văn bản trắng)',
        'text_theme_dark' => 'Tối (Văn bản đen)',
        'item_colors' => 'Màu mục ngăn kéo',
        'item_colors_description' => 'Tùy chỉnh màu biểu tượng và văn bản cho mục menu ngăn kéo',
        'item_icon_colors' => 'Màu biểu tượng mục ngăn kéo',
        'item_icon_colors_help' => 'Màu biểu tượng và văn bản mục ngăn kéo không hoạt động ở chế độ sáng và tối',
        'active_item_colors' => 'Màu mục đang hoạt động',
        'active_item_colors_help' => 'Màu của mục ngăn kéo được chọn/đang hoạt động ở chế độ sáng và tối',
        'light_mode' => 'Chế độ sáng',
        'dark_mode' => 'Chế độ tối',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'Thanh điều hướng dưới',
        'bottom_nav_bar_description' => 'Cấu hình mục tab điều hướng dưới (tối đa 8 mục)',
        'add_item' => '+ Thêm mục',
        'no_navigation_items' => 'Chưa cấu hình mục điều hướng',
        'add_first_navigation_item' => 'Thêm mục điều hướng đầu tiên',
        'home_tab_badge' => 'Tab Trang chủ - Đồng bộ với URL chính',
        'home_item_badge' => 'Mục Trang chủ - Đồng bộ với URL chính',
        'label' => 'Nhãn',
        'label_placeholder_home' => 'Trang chủ',
        'label_placeholder_about' => 'Giới thiệu',
        'action_type' => 'Loại hành động',
        'action_internal' => 'Liên kết nội bộ',
        'action_external' => 'Liên kết ngoài',
        'action_hosted_page' => 'Trang được lưu trữ',
        'action_share' => 'Chia sẻ',
        'action_email' => 'Gửi Email',
        'action_call' => 'Gọi điện',
        'url' => 'URL',
        'email_address' => 'Địa chỉ Email',
        'phone_number' => 'Số điện thoại',
        'hosted_page' => 'Trang được lưu trữ',
        'select_page' => 'Chọn một trang',
        'synced_from_general' => 'Tự động đồng bộ từ Cài đặt chung',
        'icon' => 'Biểu tượng',
        'select_icon' => 'Chọn biểu tượng',
        'search_icons' => 'Tìm kiếm biểu tượng...',
        'home_tab_cannot_delete' => 'Không thể xóa tab Trang chủ',
        'home_item_cannot_delete' => 'Không thể xóa mục Trang chủ',
        'max_navigation_items' => 'Đã đạt tối đa 8 mục điều hướng (không bao gồm tab Trang chủ)',
        'app_bar_buttons' => 'Nút thanh ứng dụng',
        'app_bar_buttons_description' => 'Thêm nút hành động ở góc trên phải thanh ứng dụng (tối đa 3 nút)',
        'add_button' => '+ Thêm nút',
        'no_app_bar_buttons' => 'Chưa cấu hình nút thanh ứng dụng',
        'add_first_app_bar_button' => 'Thêm nút thanh ứng dụng đầu tiên',
        'max_app_bar_buttons' => 'Đã đạt tối đa 3 nút thanh ứng dụng',
        'drawer_menu_items' => 'Mục menu ngăn kéo',
        'drawer_menu_items_description' => 'Cấu hình mục menu ngăn kéo điều hướng (1 trang chủ + tối đa 9 mục bổ sung)',
        'no_drawer_items' => 'Chưa cấu hình mục menu ngăn kéo',
        'add_first_drawer_item' => 'Thêm mục menu ngăn kéo đầu tiên',
        'max_drawer_items' => 'Đã đạt tối đa 9 mục bổ sung (tổng 10 bao gồm mục trang chủ)',
        'behavior_settings' => 'Cài đặt hành vi',
        'behavior_settings_description' => 'Cấu hình tương tác người dùng',
        'pull_to_refresh' => 'Kéo để làm mới',
        'pull_to_refresh_description' => 'Cho phép người dùng làm mới nội dung bằng cách kéo xuống',
        'swipe_navigation' => 'Điều hướng vuốt',
        'swipe_navigation_description' => 'Cho phép người dùng quay lại bằng cách vuốt từ cạnh',
        'swipe_navigation_disabled' => 'Đã tắt cho bố cục ngăn kéo để tránh xung đột cử chỉ',
        'preserve_tab_state' => 'Giữ trạng thái tab',
        'preserve_tab_state_description' => 'Giữ trang hiện tại khi chuyển đổi giữa các tab/mục ngăn kéo',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'Cài đặt ứng dụng',
        'general' => 'Tổng quan',
        'design' => 'Thiết kế',
        'icon' => 'Biểu tượng',
        'splashscreen' => 'Màn hình khởi động',
        'navigation' => 'Điều hướng',
        'drawer' => 'Ngăn kéo',
        'webview' => 'WebView',
        'permissions' => 'Quyền',
        'custom_code' => 'Mã tùy chỉnh',
        'hosted_pages' => 'Trang được lưu trữ',
        'notifications' => 'Thông báo',
        'deployment' => 'Triển khai',
        'builds' => 'Bản dựng',
        'signing' => 'Ký',
        'back_to_apps' => 'Quay lại ứng dụng',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'User Agent',
    'webview_user_agent_description' => 'Tùy chỉnh chuỗi user agent trình duyệt',
    'webview_custom_user_agent' => 'User Agent tùy chỉnh',
    'webview_user_agent_placeholder' => 'Để trống để sử dụng user agent Android WebView mặc định',
    'webview_user_agent_helper' => 'Tùy chọn. Ghi đè user agent mặc định gửi đến website của bạn.',
    'webview_features_title' => 'Tính năng WebView',
    'webview_features_description' => 'Cấu hình khả năng và hành vi trình duyệt',
    'webview_enable_javascript' => 'Bật JavaScript',
    'webview_enable_javascript_description' => 'Cho phép thực thi JavaScript trong WebView',
    'webview_enable_dom_storage' => 'Bật DOM Storage',
    'webview_enable_dom_storage_description' => 'Cho phép API localStorage và sessionStorage',
    'webview_enable_zoom_controls' => 'Bật điều khiển Zoom',
    'webview_enable_zoom_controls_description' => 'Cho phép phóng to bằng hai ngón tay và điều khiển zoom',
    'webview_enable_cache' => 'Bật Cache',
    'webview_enable_cache_description' => 'Lưu cache nội dung web để tải nhanh hơn',

    // Permissions Settings
    'permissions_location_title' => 'Quyền vị trí',
    'permissions_location_description' => 'Truy cập GPS thiết bị cho tính năng dựa trên vị trí',
    'permissions_enable_location' => 'Bật truy cập vị trí',
    'permissions_location_helper' => 'Bắt buộc cho bản đồ, nội dung dựa trên vị trí và tính năng geofencing.',
    'permissions_show_code_example' => 'Hiển thị ví dụ mã',
    'permissions_hide_code_example' => 'Ẩn ví dụ mã',
    'permissions_javascript_example' => 'Ví dụ JavaScript:',
    'permissions_camera_title' => 'Quyền Camera',
    'permissions_camera_description' => 'Truy cập camera thiết bị để chụp ảnh và quay video',
    'permissions_enable_camera' => 'Bật truy cập Camera',
    'permissions_camera_helper' => 'Bắt buộc để chụp ảnh, quét mã QR và gọi video.',
    'permissions_storage_title' => 'Quyền lưu trữ',
    'permissions_storage_description' => 'Truy cập bộ nhớ thiết bị để tải lên và tải xuống tệp',
    'permissions_enable_storage' => 'Bật truy cập lưu trữ',
    'permissions_storage_helper' => 'Bắt buộc để tải lên tệp, chọn ảnh và tải xuống tệp.',
    'permissions_microphone_title' => 'Quyền Microphone',
    'permissions_microphone_description' => 'Truy cập microphone thiết bị để ghi âm',
    'permissions_enable_microphone' => 'Bật truy cập Microphone',
    'permissions_microphone_helper' => 'Bắt buộc để ghi âm giọng nói, gọi âm thanh và nhận dạng giọng nói.',
    'permissions_contacts_title' => 'Quyền Danh bạ',
    'permissions_contacts_description' => 'Truy cập danh bạ thiết bị cho tính năng xã hội',
    'permissions_enable_contacts' => 'Bật truy cập Danh bạ',
    'permissions_contacts_helper' => 'Bắt buộc để chọn danh bạ, tính năng mời và tích hợp mạng xã hội.',
    'permissions_vibrate_title' => 'Quyền Rung',
    'permissions_vibrate_description' => 'Truy cập motor rung thiết bị để phản hồi xúc giác',
    'permissions_enable_vibrate' => 'Bật Rung',
    'permissions_vibrate_helper' => 'Bắt buộc cho phản hồi xúc giác và rung thông báo.',

    // Custom Code Settings
    'custom_code_access_required_title' => 'Cần nâng cấp',
    'custom_code_access_required_description' => 'Gói hiện tại của bạn không bao gồm chèn mã tùy chỉnh. Nâng cấp để truy cập tính năng này và thêm CSS và JavaScript tùy chỉnh vào ứng dụng.',
    'custom_code_upgrade_plan' => 'Nâng cấp gói của bạn',
    'custom_code_enable_feature' => 'để bật tính năng này.',
    'custom_code_css_title' => 'CSS tùy chỉnh',
    'custom_code_css_description' => 'Thêm kiểu tùy chỉnh để cá nhân hóa giao diện ứng dụng',
    'custom_code_css_label' => 'Mã CSS',
    'custom_code_css_helper' => 'Tối đa 100KB. CSS sẽ được chèn vào mọi trang.',
    'custom_code_js_title' => 'JavaScript tùy chỉnh',
    'custom_code_js_description' => 'Thêm script tùy chỉnh cho chức năng mở rộng',
    'custom_code_js_label' => 'Mã JavaScript',
    'custom_code_js_helper' => 'Tối đa 100KB. JavaScript sẽ được thực thi trong webview.',

    // Notifications Settings
    'notifications_title' => 'Thông báo',
    'notifications_description' => 'Cấu hình Firebase Cloud Messaging (FCM) cho thông báo',
    'notifications_enable' => 'Bật thông báo',
    'notifications_firebase_service_account' => 'Tài khoản dịch vụ Firebase',
    'notifications_firebase_service_account_description' => 'Được máy chủ sử dụng để gửi thông báo qua FCM API',
    'notifications_firebase_help_text' => 'Tệp JSON (TỐI ĐA 2MB)',
    'notifications_delete_firebase_credentials' => 'Xóa thông tin Firebase',
    'notifications_delete_firebase_credentials_confirm' => 'Bạn có chắc chắn muốn xóa tệp thông tin Firebase?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Bắt buộc cho cấu hình ứng dụng Android',
    'notifications_google_services_help_text' => 'Tệp JSON (TỐI ĐA 1MB)',
    'notifications_delete_google_services' => 'Xóa tệp Google Services',
    'notifications_delete_google_services_confirm' => 'Bạn có chắc chắn muốn xóa tệp Google Services?',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Android Keystores',
        'generate_new' => 'Tạo mới',
        'upload_existing' => 'Tải lên có sẵn',
        'default_badge' => 'Mặc định',
        'alias' => 'Alias',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => 'Tự động tạo',
        'created' => 'Đã tạo',
        'set_as_default' => 'Đặt làm mặc định',
        'edit' => 'Sửa',
        'delete' => 'Xóa',
        'no_keystores' => 'Chưa có Android keystores. Tạo khóa mới hoặc tải lên có sẵn.',
        'upload_signing_key' => 'Tải lên khóa ký',
        'android_keystore_upload' => 'Tải lên Android Keystore',
        'keystore_name' => 'Tên Keystore',
        'keystore_name_placeholder' => 'Keystore phát hành của tôi',
        'keystore_file' => 'Tệp Keystore',
        'keystore_file_help' => 'Tệp .jks, .keystore hoặc .ks (Tối đa 5MB)',
        'upload_custom_key' => 'Tải lên khóa tùy chỉnh',
        'upload_custom_key_help' => 'Bỏ chọn nếu sử dụng keystore debug tự động tạo',
        'password' => 'Mật khẩu',
        'password_placeholder' => '••••••••',
        'password_help' => 'Dùng cho cả truy cập keystore và khóa',
        'cancel' => 'Hủy',
        'upload' => 'Tải lên',
        'edit_keystore' => 'Sửa Keystore',
        'update_password' => 'Cập nhật mật khẩu',
        'save' => 'Lưu',
        'delete_keystore' => 'Xóa Keystore',
        'delete_confirmation' => 'Bạn có chắc chắn muốn xóa',
        'action_cannot_be_undone' => 'Hành động này không thể hoàn tác.',

        // Keystore Generator Modal
        'generate_signing_key' => 'Tạo khóa ký',
        'generate_android_keystore' => 'Tạo Android Keystore',
        'generate_keystore_description' => 'Keystore JKS mới sẽ được tạo an toàn trên máy chủ build',
        'keystore_name_generate_placeholder' => 'Khóa phát hành ứng dụng của tôi',
        'key_alias' => 'Key Alias',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => 'Phải bắt đầu bằng chữ cái. Cho phép chữ cái, số, gạch ngang và gạch dưới.',
        'password_settings' => 'Cài đặt mật khẩu',
        'keystore_password' => 'Mật khẩu Keystore',
        'min_characters_placeholder' => 'Tối thiểu 6 ký tự',
        'use_same_password' => 'Sử dụng cùng mật khẩu cho khóa và keystore',
        'key_password' => 'Mật khẩu khóa',
        'validity_period' => 'Thời hạn hiệu lực',
        'years_10' => '10 năm',
        'years_15' => '15 năm',
        'years_20' => '20 năm',
        'years_25_recommended' => '25 năm (Khuyến nghị)',
        'years_30' => '30 năm',
        'validity_help' => 'Google Play yêu cầu ít nhất 25 năm hiệu lực cho ứng dụng mới',
        'certificate_details' => 'Chi tiết chứng chỉ (Tùy chọn)',
        'common_name' => 'Tên chung (CN)',
        'common_name_placeholder' => 'Tên ứng dụng hoặc tổ chức của bạn',
        'organization' => 'Tổ chức (O)',
        'organization_placeholder' => 'Tên công ty',
        'organizational_unit' => 'Đơn vị tổ chức (OU)',
        'organizational_unit_placeholder' => 'Ứng dụng di động',
        'city' => 'Thành phố (L)',
        'city_placeholder' => 'Hồ Chí Minh',
        'state' => 'Tỉnh/Bang (ST)',
        'state_placeholder' => 'HCM',
        'country' => 'Quốc gia (C)',
        'country_placeholder' => 'VN',
        'save_password_warning' => 'Quan trọng: Lưu mật khẩu của bạn một cách an toàn!',
        'save_password_description' => 'Keystore sẽ được mã hóa và lưu trữ. Bạn sẽ cần mật khẩu cho các bản dựng tương lai. Không có cách nào để khôi phục mật khẩu bị mất.',
        'generating' => 'Đang tạo...',
        'generate_keystore' => 'Tạo Keystore',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'Cần truy cập trang được lưu trữ',
        'upgrade_description' => 'Gói hiện tại của bạn không bao gồm trang được lưu trữ. Nâng cấp gói để tạo trang tùy chỉnh được lưu trữ bởi chúng tôi.',
        'upgrade_plan' => 'Nâng cấp gói của bạn',
        'upgrade_suffix' => 'để bật tính năng này.',
        'table_page' => 'Trang',
        'table_status' => 'Trạng thái',
        'table_created' => 'Đã tạo',
        'table_actions' => 'Hành động',
        'status_published' => 'Đã xuất bản',
        'status_draft' => 'Bản nháp',
        'edit' => 'Sửa',
        'delete' => 'Xóa',
        'no_pages' => 'Chưa có trang nào',
        'no_pages_description' => 'Nhấp "Thêm trang" để tạo trang được lưu trữ đầu tiên.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'Tạo trang',
        'edit_page' => 'Sửa trang',
        'title' => 'Tiêu đề',
        'title_placeholder' => 'Tiêu đề trang',
        'slug' => 'Slug',
        'slug_placeholder' => 'page-slug',
        'start_from_template' => 'Bắt đầu từ mẫu',
        'status' => 'Trạng thái',
        'status_help' => 'Chỉ các trang đã xuất bản mới có thể truy cập trong ứng dụng',
        'cancel' => 'Hủy',
        'save_changes' => 'Lưu thay đổi',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'Ứng dụng WordPress của tôi',
        'wordpress_site_url' => 'URL trang WordPress',
        'wordpress_site_url_placeholder' => 'https://myblog.wordpress.com',
        'wordpress_site_url_help' => 'Nhập URL trang WordPress.com của bạn (ví dụ: myblog.wordpress.com)',
        'app_id_placeholder' => 'com.example.wordpress',
        'package_name_help' => 'Định danh duy nhất theo định dạng domain đảo ngược (ví dụ: com.company.wordpress). Không thể thay đổi sau khi tạo.',

        // Design Settings
        'post_list_style' => 'Kiểu danh sách bài viết',
        'style_list' => 'Danh sách',
        'style_grid' => 'Lưới',
        'style_magazine' => 'Tạp chí',
        'post_list_style_help' => 'Cách hiển thị bài viết trong ứng dụng',
        'progress_indicator_help' => 'Kiểu chỉ báo tải hiển thị khi tải bài viết',
        'show_app_bar_title' => 'Hiển thị tên ứng dụng trên thanh ứng dụng',
        'show_app_bar_title_help' => 'Hiển thị tên ứng dụng trên thanh trên cùng',
        'nav_tab_icon_colors_help' => 'Màu biểu tượng tab không hoạt động',
        'active_tab_colors_help' => 'Màu của tab được chọn',
        'theme_color_help' => 'Màu chính sử dụng xuyên suốt ứng dụng (màu WordPress: #21759B)',
        'dynamic_colors_help' => 'Khi bật, ứng dụng sẽ điều chỉnh màu từ hình nền người dùng trên thiết bị Android 12+.',
        'layout_list_only' => 'Chỉ danh sách',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'Ứng dụng WordPress của tôi',
        'splashscreen_subtitle_placeholder' => 'Chào mừng đến ứng dụng blog tốt nhất',

        // Sidebar
        'content' => 'Nội dung',
        'features' => 'Tính năng',

        // Drawer Settings
        'drawer_appearance_description' => 'Tùy chỉnh nền ngăn kéo điều hướng',
        'drawer_branding_description' => 'Logo, tiêu đề và kiểu văn bản',
        'logo_light_mode' => 'Logo (Chế độ sáng)',
        'logo_dark_mode' => 'Logo (Chế độ tối)',
        'png_transparency_help' => 'PNG trong suốt (TỐI ĐA 2MB)',
        'delete_background' => 'Xóa nền',
        'drawer_title_placeholder' => 'Ứng dụng WordPress của tôi',
        'drawer_subtitle_placeholder' => 'Khẩu hiệu của bạn tại đây',
        'item_colors_description' => 'Màu biểu tượng và văn bản cho mục menu',
        'inactive_item_colors' => 'Màu mục không hoạt động',

        // Navigation Settings
        'bottom_nav_tabs' => 'Tab điều hướng dưới',
        'bottom_nav_tabs_description' => 'Cấu hình mục điều hướng dưới (tối đa 8 + trang chủ)',
        'add_tab' => '+ Thêm tab',
        'home_tab_shows_all_posts' => 'Tab Trang chủ - Hiển thị tất cả bài viết',
        'home_item_shows_all_posts' => 'Mục Trang chủ - Hiển thị tất cả bài viết',
        'tab_name_placeholder' => 'Tên tab',
        'menu_item_placeholder' => 'Mục menu',
        'action_category' => 'Danh mục',
        'action_tag' => 'Thẻ',
        'action_search' => 'Tìm kiếm',
        'action_bookmarks' => 'Đánh dấu',
        'action_share' => 'Chia sẻ',
        'category_slug' => 'Slug danh mục',
        'tag_slug' => 'Slug thẻ',
        'category_slug_placeholder' => 'technology',
        'tag_slug_placeholder' => 'featured',
        'app_bar_buttons_description' => 'Nút hành động ở góc trên phải (tối đa 3)',
        'no_app_bar_buttons_description' => 'Chưa cấu hình nút thanh ứng dụng. Thêm tìm kiếm, chia sẻ hoặc hành động nhanh khác.',
        'search_placeholder' => 'Tìm kiếm',
        'drawer_menu_items_description' => 'Mục menu ngăn kéo điều hướng (1 trang chủ + tối đa 9 mục)',
        'swipe_navigation_description' => 'Quay lại bằng cách vuốt từ cạnh',
        'preserve_tab_state_description' => 'Giữ vị trí cuộn khi chuyển tab',

        // Content Settings
        'post_display' => 'Hiển thị bài viết',
        'post_display_description' => 'Cấu hình cách hiển thị bài viết trong ứng dụng',
        'posts_per_page' => 'Bài viết mỗi trang',
        'posts_per_page_help' => 'Số bài viết tải mỗi lần (1-50)',
        'excerpt_length' => 'Độ dài trích đoạn (ký tự)',
        'excerpt_length_help' => 'Số ký tự tối đa hiển thị trong trích đoạn bài viết (50-500)',
        'post_metadata' => 'Metadata bài viết',
        'post_metadata_description' => 'Chọn thông tin hiển thị với mỗi bài viết',
        'show_featured_image' => 'Hiển thị hình ảnh nổi bật',
        'show_featured_image_help' => 'Hiển thị hình ảnh nổi bật/thumbnail của bài viết',
        'show_excerpt' => 'Hiển thị trích đoạn bài viết',
        'show_excerpt_help' => 'Hiển thị xem trước nội dung bài viết',
        'show_author' => 'Hiển thị tên tác giả',
        'show_author_help' => 'Hiển thị tác giả viết bài',
        'show_date' => 'Hiển thị ngày đăng',
        'show_date_help' => 'Hiển thị khi bài viết được đăng',
        'show_categories' => 'Hiển thị danh mục',
        'show_categories_help' => 'Hiển thị danh mục được gán cho bài viết',
        'show_reading_time' => 'Hiển thị thời gian đọc ước tính',
        'show_reading_time_help' => 'Hiển thị thời gian cần để đọc bài viết',

        // Features Settings
        'core_features' => 'Tính năng cốt lõi',
        'core_features_description' => 'Bật hoặc tắt chức năng ứng dụng',
        'enable_search' => 'Bật tìm kiếm',
        'enable_search_help' => 'Cho phép người dùng tìm kiếm bài viết trong ứng dụng',
        'enable_comments' => 'Bật bình luận',
        'enable_comments_help' => 'Cho phép người dùng xem và đăng bình luận trên bài viết',
        'enable_bookmarks' => 'Bật đánh dấu',
        'enable_bookmarks_help' => 'Cho phép người dùng lưu bài viết để đọc sau',
        'enable_share' => 'Bật chia sẻ',
        'enable_share_help' => 'Cho phép người dùng chia sẻ bài viết qua các ứng dụng khác',
        'advanced_features' => 'Tính năng nâng cao',
        'advanced_features_description' => 'Chức năng bổ sung để nâng cao trải nghiệm người dùng',
        'enable_offline_reading' => 'Bật đọc offline',
        'enable_offline_reading_help' => 'Lưu cache bài viết để đọc khi không có internet',
        'enable_user_auth' => 'Bật xác thực người dùng',
        'enable_user_auth_help' => 'Cho phép người dùng đăng nhập bằng tài khoản WordPress.com',
        'enable_push_notifications' => 'Bật thông báo đẩy',
        'enable_push_notifications_help' => 'Gửi thông báo khi có bài viết mới',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'Tìm kiếm bản dựng...',
        'filter' => 'Lọc',
        'platform_filter' => 'Nền tảng',
        'status_filter' => 'Trạng thái',
        'android' => 'Android',
        'completed' => 'Hoàn thành',
        'building' => 'Đang dựng',
        'failed' => 'Thất bại',
        'pending' => 'Đang chờ',
        'table_platform' => 'Nền tảng',
        'table_build_info' => 'Thông tin bản dựng',
        'table_created' => 'Đã tạo',
        'table_actions' => 'Hành động',
        'release' => 'Phát hành',
        'debug' => 'Debug',
        'download' => 'Tải xuống',
        'preview' => 'Xem trước',
        'logs' => 'Nhật ký',
        'delete' => 'Xóa',
        'no_builds' => 'Không tìm thấy bản dựng',

        // Build Modal
        'create_new_build' => 'Tạo bản dựng mới',
        'platform_label' => 'Nền tảng',
        'build_costs_credit' => 'Bản dựng tốn :count tín dụng|Bản dựng tốn :count tín dụng',
        'build_type_label' => 'Loại bản dựng',
        'for_testing' => 'Để thử nghiệm',
        'for_production' => 'Cho production',
        'output_format_label' => 'Định dạng đầu ra',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'Để thử nghiệm/cài đặt trực tiếp',
        'for_google_play_store' => 'Cho Google Play Store',
        'builder_label' => 'Builder',
        'auto_select_recommended' => 'Tự động chọn (khuyến nghị)',
        'auto_select_help' => 'Để "Tự động chọn" để sử dụng builder ít bận nhất, hoặc chọn builder cụ thể.',
        'no_builders_available' => 'Không có builder nào!',
        'no_builders_help' => 'Gói của bạn không có quyền truy cập builder nào. Vui lòng liên hệ hỗ trợ hoặc nâng cấp gói.',
        'signing_key_label' => 'Khóa ký',
        'select_keystore' => 'Chọn keystore',
        'no_keystores_available' => 'Không có keystore nào.',
        'upload_in_signing_section' => 'Tải lên trong phần Ký',
        'signing_key_required' => 'Cần khóa ký!',
        'version_name_label' => 'Tên phiên bản',
        'version_name_help' => 'Định dạng: X.Y hoặc X.Y.Z (ví dụ: 1.0 hoặc 1.0.0). Tự động tăng cho mỗi nền tảng.',
        'build_number_label' => 'Số bản dựng',
        'next_build_number' => 'Số bản dựng tiếp theo',
        'build_number_auto_increment' => 'Số bản dựng tự động tăng với mỗi bản dựng',
        'build_cost_info' => 'Bản dựng này sẽ tốn :count tín dụng|Bản dựng này sẽ tốn :count tín dụng',
        'build_email_notification' => 'Bạn sẽ nhận email khi bản dựng sẵn sàng tải xuống.',
        'cancel' => 'Hủy',
        'start_build' => 'Bắt đầu dựng',
        'credit' => 'tín dụng',
        'credits' => 'tín dụng',
        'builder_info' => 'Builder:',

        // Build Logs Modal
        'build_logs' => 'Nhật ký bản dựng',
        'duration' => 'Thời lượng:',
        'no_logs_available' => 'Không có nhật ký cho bản dựng này',
        'error' => 'Lỗi:',
        'close' => 'Đóng',
        'download_build' => 'Tải xuống bản dựng',

        // Build Download Modal
        'download_build_title' => 'Tải xuống bản dựng',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'Đây là tệp AAB không thể cài đặt trực tiếp trên thiết bị. Tệp AAB được thiết kế để tải lên Google Play Console, nơi Google sẽ tạo APK tối ưu hóa cho người dùng.',
        'scan_with_android' => 'Quét bằng thiết bị Android của bạn',
        'qr_unavailable' => 'Mã QR không khả dụng',
        'download_options' => 'Tùy chọn tải xuống',
        'download_options_description' => 'Quét mã QR bằng thiết bị di động hoặc sử dụng liên kết tải xuống trực tiếp bên dưới.',
        'download_format' => 'Tải xuống :format',
        'installation_note' => 'Cài đặt:',
        'installation_help' => 'Bạn có thể cần bật "Cài đặt từ nguồn không xác định" trong cài đặt Android.',
        'download_aab_file' => 'Tải xuống tệp AAB',
        'upload_to_play_console' => 'Tải tệp này lên Google Play Console để xuất bản ứng dụng.',
        'next_steps' => 'Bước tiếp theo:',
        'next_steps_help' => 'Tải tệp AAB này lên Google Play Console trong Phát hành > Production/Testing. Google sẽ tự động tạo APK tối ưu hóa cho người dùng của bạn.',

        // Delete Build Modal
        'delete_build' => 'Xóa bản dựng',
        'delete_confirmation' => 'Bạn có chắc chắn muốn xóa bản dựng',
        'build_suffix' => '?',
        'action_cannot_be_undone' => 'Hành động này không thể hoàn tác.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'Chưa chọn bản dựng',
        'select_build_help' => 'Chọn bản dựng hoàn thành từ tab Bản dựng để xem trước tại đây',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'URL Website',
        'app_id' => 'APP ID',
        'app_id_tooltip' => 'Định danh gói duy nhất (không thể thay đổi sau khi tạo)',
        'auto_generate_package' => 'Tự động tạo từ tên ứng dụng',
        'package_name_help' => 'Định danh duy nhất theo định dạng domain đảo ngược (ví dụ: com.company.app). Không thể thay đổi sau khi tạo.',
        'theme_color' => 'Màu chủ đề',
        'theme_color_help' => 'Màu chính sử dụng xuyên suốt ứng dụng. Màu văn bản sẽ sử dụng đen/trắng mặc định và có thể tùy chỉnh sau.',
        'layout_template' => 'Mẫu bố cục',
        'layout_app_bar_drawer' => 'Thanh ứng dụng + Ngăn kéo',
        'layout_app_bar_tabs' => 'Thanh ứng dụng + Tab điều hướng',
        'layout_app_bar' => 'Thanh ứng dụng',
        'layout_blank' => 'Trống',
        'layout_help' => 'Chọn cấu trúc điều hướng cho ứng dụng của bạn',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'Hủy',
        'delete' => 'Xóa',
        'action_cannot_be_undone' => 'Hành động này không thể hoàn tác.',
        'delete_build' => 'Xóa bản dựng',
        'delete_build_confirmation' => 'Bạn có chắc chắn muốn xóa bản dựng',
        'build_suffix' => '?',
        'delete_app_icon' => 'Xóa biểu tượng ứng dụng',
        'delete_icon_confirmation' => 'Bạn có chắc chắn muốn xóa biểu tượng cho',
        'delete_keystore' => 'Xóa Keystore',
        'delete_keystore_confirmation' => 'Bạn có chắc chắn muốn xóa',
        'delete_splashscreen_background' => 'Xóa nền màn hình khởi động',
        'delete_splashscreen_background_confirmation' => 'Bạn có chắc chắn muốn xóa hình nền màn hình khởi động cho',
        'delete_splashscreen_logo' => 'Xóa logo màn hình khởi động',
        'delete_splashscreen_logo_confirmation' => 'Bạn có chắc chắn muốn xóa logo màn hình khởi động cho',
        'delete_drawer_background' => 'Xóa nền ngăn kéo',
        'delete_drawer_background_confirmation' => 'Bạn có chắc chắn muốn xóa hình nền ngăn kéo cho',
        'delete_dark_mode_logo' => 'Xóa logo chế độ tối',
        'delete_dark_mode_logo_confirmation' => 'Bạn có chắc chắn muốn xóa logo chế độ tối ngăn kéo cho',
        'delete_light_mode_logo' => 'Xóa logo chế độ sáng',
        'delete_light_mode_logo_confirmation' => 'Bạn có chắc chắn muốn xóa logo chế độ sáng ngăn kéo cho',
        'delete_page' => 'Xóa trang',
        'delete_page_confirmation' => 'Bạn có chắc chắn muốn xóa',
        'delete_page_warning' => 'Hành động này không thể hoàn tác. Nếu trang này được sử dụng trong điều hướng, nó sẽ không còn truy cập được.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'Thông báo đẩy',
        'description' => 'Cấu hình Firebase Cloud Messaging cho thông báo đẩy',
        'enable_label' => 'Bật thông báo đẩy',
        'enable_help' => 'Gửi thông báo khi có bài viết mới',
        'firebase_required_title' => 'Cần cấu hình Firebase',
        'firebase_required_description' => 'Tải lên cả hai tệp cấu hình bên dưới để bật thông báo đẩy trong ứng dụng.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'Tệp đã tải lên',
        'google_services_configured' => 'google-services.json đã được cấu hình',
        'delete' => 'Xóa',
        'delete_file_confirm' => 'Bạn có chắc chắn muốn xóa tệp này?',
        'upload_google_services' => 'Tải lên google-services.json',
        'google_services_help' => 'Tải từ Firebase Console (TỐI ĐA 1MB)',
        'google_services_instructions' => 'Tải từ Firebase Console > Cài đặt dự án > Ứng dụng của bạn > Ứng dụng Android',
        'firebase_service_account_label' => 'Tài khoản dịch vụ Firebase (để gửi thông báo)',
        'credentials_configured' => 'Thông tin đã cấu hình',
        'service_account_stored' => 'Tài khoản dịch vụ được lưu trữ an toàn',
        'delete_credentials_confirm' => 'Bạn có chắc chắn muốn xóa thông tin này?',
        'upload_service_account' => 'Tải lên JSON tài khoản dịch vụ',
        'service_account_help' => 'Tải từ Firebase Console (TỐI ĐA 2MB)',
        'service_account_instructions' => 'Tải từ Firebase Console > Cài đặt dự án > Tài khoản dịch vụ > Tạo khóa riêng mới',
        'setup_title' => 'Cách thiết lập Firebase:',
        'setup_step_1' => 'Truy cập',
        'setup_step_2' => 'Tạo dự án hoặc chọn dự án hiện có',
        'setup_step_3' => 'Thêm ứng dụng Android với tên gói của bạn:',
        'setup_step_4' => 'Tải',
        'setup_step_4_suffix' => 'và tải lên ở trên',
        'setup_step_5' => 'Đi đến Cài đặt dự án > Tài khoản dịch vụ',
        'setup_step_6' => 'Tạo khóa riêng mới và tải lên ở trên',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => 'Cài đặt :section đã lưu thành công!',
        'settings_save_failed' => 'Không thể lưu cài đặt. Vui lòng thử lại.',

        // Design settings
        'design_saved' => 'Cài đặt thiết kế đã lưu thành công!',

        // Navigation settings
        'navigation_saved' => 'Cài đặt điều hướng đã lưu thành công!',
        'home_tab_cannot_delete' => 'Không thể xóa tab Trang chủ. Nó là bắt buộc cho điều hướng.',
        'home_tab_cannot_move' => 'Tab Trang chủ phải ở vị trí đầu tiên và không thể di chuyển.',
        'cannot_move_below_home' => 'Không thể di chuyển mục xuống dưới tab trang chủ.',
        'home_item_cannot_delete' => 'Không thể xóa mục Trang chủ. Nó là bắt buộc cho điều hướng.',
        'home_item_cannot_move' => 'Mục Trang chủ phải ở vị trí đầu tiên và không thể di chuyển.',
        'cannot_move_below_home_item' => 'Không thể di chuyển mục xuống dưới mục trang chủ.',

        // Custom code
        'custom_code_saved' => 'Mã tùy chỉnh đã lưu thành công!',
        'custom_code_save_failed' => 'Không thể lưu mã tùy chỉnh. Vui lòng thử lại.',
        'custom_code_no_access' => 'Gói của bạn không bao gồm truy cập mã tùy chỉnh. Vui lòng nâng cấp gói.',

        // WebView settings
        'webview_saved' => 'Cài đặt WebView đã lưu thành công!',

        // Permissions settings
        'permissions_saved' => 'Quyền đã lưu thành công!',

        // Drawer settings
        'drawer_saved' => 'Cài đặt ngăn kéo đã lưu thành công!',

        // General settings
        'general_saved' => 'Cài đặt chung đã lưu thành công!',

        // Splashscreen settings
        'splashscreen_saved' => 'Cài đặt màn hình khởi động đã lưu thành công!',

        // Icon settings
        'icon_uploaded' => 'Biểu tượng ứng dụng đã tải lên thành công!',
        'icon_upload_failed' => 'Không thể tải lên biểu tượng: :error',
        'icon_removed' => 'Biểu tượng ứng dụng đã xóa thành công!',
        'icon_remove_failed' => 'Không thể xóa biểu tượng. Vui lòng thử lại.',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'Hình nền màn hình khởi động đã xóa thành công!',
        'splashscreen_background_delete_failed' => 'Không thể xóa hình nền. Vui lòng thử lại.',
        'splashscreen_logo_deleted' => 'Logo màn hình khởi động đã xóa thành công!',
        'splashscreen_logo_delete_failed' => 'Không thể xóa logo. Vui lòng thử lại.',

        // Drawer modals
        'drawer_background_deleted' => 'Hình nền ngăn kéo đã xóa thành công!',
        'drawer_background_delete_failed' => 'Không thể xóa hình nền. Vui lòng thử lại.',
        'drawer_logo_deleted' => 'Logo ngăn kéo đã xóa thành công!',
        'drawer_logo_delete_failed' => 'Không thể xóa logo. Vui lòng thử lại.',
        'drawer_logo_light_deleted' => 'Logo chế độ sáng ngăn kéo đã xóa thành công!',
        'drawer_logo_dark_deleted' => 'Logo chế độ tối ngăn kéo đã xóa thành công!',

        // Notifications settings
        'notifications_saved' => 'Cài đặt thông báo đã lưu thành công!',
        'firebase_credentials_deleted' => 'Thông tin Firebase đã xóa thành công!',
        'firebase_credentials_delete_failed' => 'Không thể xóa thông tin Firebase. Vui lòng thử lại.',
        'google_services_deleted' => 'Tệp Google Services đã xóa thành công!',
        'google_services_delete_failed' => 'Không thể xóa tệp Google Services. Vui lòng thử lại.',

        // Signing keys
        'keystore_updated' => 'Keystore đã cập nhật thành công!',
        'keystore_update_failed' => 'Không thể cập nhật keystore.',
        'keystore_load_failed' => 'Không thể tải keystore.',
        'keystore_deleted' => 'Keystore đã xóa thành công!',
        'keystore_delete_failed' => 'Không thể xóa keystore. Vui lòng thử lại.',
        'keystore_uploaded' => 'Keystore đã tải lên thành công!',
        'keystore_upload_failed' => 'Không thể tải lên khóa ký: :error',
        'keystore_generated' => 'Keystore đã tạo thành công!',
        'keystore_set_default' => 'Keystore mặc định đã cập nhật thành công!',

        // Build modal
        'build_no_builders_platform' => 'Không có builder nào cho nền tảng :platform. Vui lòng liên hệ hỗ trợ hoặc nâng cấp gói.',
        'build_no_subscription' => 'Bạn cần đăng ký đang hoạt động để dựng ứng dụng. Vui lòng đăng ký gói.',
        'build_no_builders_plan' => 'Không có builder nào cho gói của bạn. Vui lòng liên hệ hỗ trợ hoặc nâng cấp gói.',
        'build_builder_not_available' => 'Builder được chọn không khả dụng cho gói của bạn.',
        'build_builder_unavailable' => 'Builder được chọn hiện không khả dụng.',
        'build_builder_no_platform' => 'Builder được chọn không hỗ trợ nền tảng :platform.',
        'build_insufficient_credits' => 'Không đủ tín dụng dựng. Bản dựng này cần :count tín dụng. Vui lòng nâng cấp gói hoặc chờ reset hàng tháng.',
        'build_keystore_required' => 'Cần Android keystore cho bản dựng phát hành. Vui lòng chọn keystore.',
        'build_keystore_invalid' => 'Keystore được chọn không hợp lệ.',
        'build_already_in_progress' => 'Bản dựng :platform đang trong quá trình. Vui lòng chờ hoàn thành.',
        'build_queued' => 'Bản dựng :platform đã xếp hàng thành công! Bản dựng sẽ được xử lý khi có builder. (:credits tín dụng còn lại)',
        'build_queued_on_builder' => 'Bản dựng :platform đã xếp hàng thành công trên :builder! (:credits tín dụng còn lại)',
        'build_create_failed' => 'Không thể tạo bản dựng: :error',
        'build_deleted' => 'Bản dựng đã xóa thành công!',
        'build_delete_failed' => 'Không thể xóa bản dựng. Vui lòng thử lại.',

        // Hosted pages
        'hosted_page_saved' => 'Trang đã lưu thành công!',
        'hosted_page_save_failed' => 'Không thể lưu trang. Vui lòng thử lại.',
        'hosted_page_deleted' => 'Trang đã xóa thành công!',
        'hosted_page_delete_failed' => 'Không thể xóa trang. Vui lòng thử lại.',
        'hosted_page_limit_reached' => 'Bạn đã đạt số trang được lưu trữ tối đa cho gói của bạn.',
        'hosted_page_no_access' => 'Gói hiện tại của bạn không bao gồm trang được lưu trữ. Nâng cấp gói để tạo trang tùy chỉnh.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => 'Cài đặt tính năng đã lưu thành công!',
        'content_saved' => 'Cài đặt nội dung đã lưu thành công!',
        'storage_link_missing' => 'Không tìm thấy liên kết lưu trữ. Chạy: php artisan storage:link',
        'splashscreen_image_deleted' => 'Hình nền màn hình khởi động đã xóa thành công!',
        'splashscreen_image_delete_failed' => 'Không thể xóa hình nền. Vui lòng thử lại.',
        'logo_delete_failed' => 'Không thể xóa logo. Vui lòng thử lại.',
        'default_key_updated' => 'Khóa ký mặc định đã cập nhật thành công!',
        'default_key_update_failed' => 'Không thể cập nhật khóa ký mặc định.',
        'keystore_uploaded_default' => 'Keystore đã tải lên và đặt làm mặc định!',
        'signing_key_upload_failed' => 'Không thể tải lên khóa ký: :error',
        'page_not_found' => 'Không tìm thấy trang.',
        'page_deleted' => 'Trang đã xóa thành công!',
        'page_delete_failed' => 'Không thể xóa trang. Vui lòng thử lại.',
        'page_updated' => 'Trang đã cập nhật thành công!',
        'page_created' => 'Trang đã tạo thành công!',
        'page_save_failed' => 'Không thể lưu trang. Vui lòng thử lại.',
        'page_limit_reached' => 'Bạn đã đạt tối đa :max trang cho gói của bạn.',
        'hosted_pages_not_available' => 'Gói của bạn không bao gồm trang được lưu trữ. Vui lòng nâng cấp gói.',
        'unauthorized' => 'Hành động không được phép.',
        'home_tab_required' => 'Không thể xóa tab Trang chủ. Nó là bắt buộc cho điều hướng.',
        'home_tab_first' => 'Tab Trang chủ phải ở vị trí đầu tiên.',
        'home_item_required' => 'Không thể xóa mục Trang chủ.',
        'build_no_builders' => 'Không có builder nào cho nền tảng :platform. Vui lòng liên hệ hỗ trợ hoặc nâng cấp gói.',
        'build_no_plan_builders' => 'Không có builder nào cho gói của bạn. Vui lòng liên hệ hỗ trợ hoặc nâng cấp gói.',
        'build_builder_platform_unsupported' => 'Builder được chọn không hỗ trợ nền tảng :platform.',
        'build_insufficient_credits' => 'Không đủ tín dụng dựng. Bản dựng này cần :credits tín dụng. Vui lòng nâng cấp gói hoặc chờ reset hàng tháng.',
        'build_invalid_keystore' => 'Keystore được chọn không hợp lệ.',
        'build_queued_no_builder' => 'Bản dựng :platform đã xếp hàng thành công! Bản dựng sẽ được xử lý khi có builder. (:credits tín dụng còn lại)',
        'build_queued_success' => 'Bản dựng :platform đã xếp hàng thành công trên :builder! (:credits tín dụng còn lại)',
        'available_builder' => 'builder khả dụng',
        'invalid_google_services_json' => 'Tệp JSON không hợp lệ. Vui lòng tải lên tệp google-services.json hợp lệ.',
        'invalid_google_services_structure' => 'google-services.json không hợp lệ. Thiếu phần project_info hoặc client bắt buộc.',
        'invalid_firebase_service_account' => 'Tệp JSON không hợp lệ. Vui lòng tải lên tệp tài khoản dịch vụ Firebase hợp lệ.',
        'invalid_firebase_service_account_type' => 'Tệp tài khoản dịch vụ Firebase không hợp lệ. Thiếu hoặc trường type không hợp lệ.',
        'settings_save_failed_error' => 'Không thể lưu cài đặt: :error',
        'file_delete_failed' => 'Không thể xóa tệp: :error',
        'credentials_delete_failed' => 'Không thể xóa thông tin: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => 'Tổng quan',
        'general_description' => 'Thông tin cơ bản và cài đặt cấu hình',
        'design' => 'Thiết kế',
        'design_description' => 'Tùy chỉnh bố cục, màu sắc và cài đặt chủ đề',
        'icon' => 'Biểu tượng',
        'icon_description' => 'Tải lên biểu tượng ứng dụng cho Android',
        'splashscreen' => 'Màn hình khởi động',
        'splashscreen_description' => 'Cấu hình giao diện và hoạt ảnh màn hình khởi động',
        'navigation' => 'Điều hướng',
        'navigation_description' => 'Quản lý mục điều hướng và nút thanh ứng dụng',
        'drawer' => 'Cài đặt ngăn kéo',
        'drawer_description' => 'Tùy chỉnh giao diện và thương hiệu menu ngăn kéo',
        'webview' => 'Cài đặt WebView',
        'webview_description' => 'Cấu hình hành vi và tính năng WebView',
        'permissions' => 'Quyền',
        'permissions_description' => 'Cấu hình quyền thiết bị ứng dụng sẽ yêu cầu',
        'custom_code' => 'Mã tùy chỉnh',
        'custom_code_description' => 'Chèn CSS và JavaScript tùy chỉnh vào ứng dụng',
        'hosted_pages' => 'Trang được lưu trữ',
        'hosted_pages_description' => 'Tạo trang HTML tùy chỉnh được lưu trữ bởi chúng tôi cho ứng dụng của bạn',
        'pages' => 'Trang',
        'add_page' => 'Thêm trang',
        'notifications' => 'Thông báo',
        'notifications_description' => 'Cấu hình Firebase Cloud Messaging cho thông báo',
        'builds' => 'Bản dựng',
        'builds_description' => 'Tạo tệp APK và AAB Android để triển khai',
        'credits' => 'Tín dụng',
        'new_build' => 'Bản dựng mới',
        'signing' => 'Ký',
        'signing_description' => 'Quản lý khóa ký cho phân phối ứng dụng',
        // WordPress-specific sections
        'general_description_wordpress' => 'Thông tin cơ bản và cấu hình trang WordPress',
        'content' => 'Nội dung',
        'content_description' => 'Cấu hình hiển thị bài viết và cài đặt nội dung',
        'features' => 'Tính năng',
        'features_description' => 'Bật hoặc tắt tính năng ứng dụng',
    ],

];
