<?php

return [
    // Page Titles
    'admin_overview' => '管理概览',
    'overview_title' => '概览',
    'users_title' => '用户',
    'subscriptions_title' => '订阅',
    'transactions_title' => '交易',
    'plans_title' => '套餐',
    'builders_title' => '构建器',
    'plugins_title' => '插件',
    'languages_title' => '语言',
    'cronjobs_title' => '定时任务',
    'email_templates_title' => '邮件模板',
    'audit_logs_title' => '审计日志',
    'settings_title' => '设置',

    // Page Subtitles
    'users_subtitle' => '管理平台用户和账户',
    'subscriptions_subtitle' => '监控用户订阅和账单',
    'transactions_subtitle' => '查看和管理支付交易',
    'plans_subtitle' => '配置订阅套餐和定价',
    'builders_subtitle' => '管理应用编译构建器',
    'plugins_subtitle' => '管理已安装的插件',
    'languages_subtitle' => '管理可用语言',
    'cronjobs_subtitle' => '监控计划任务',
    'email_templates_subtitle' => '自定义发送给用户的邮件通知',
    'cronjobs_subtitle_full' => '监控计划任务和自动化',
    'settings_subtitle_full' => '配置系统范围的设置和偏好',
    'search_settings' => '搜索设置...',
    'no_settings_found' => '未找到匹配的设置',
    'system_settings' => '系统设置',
    'clear_search' => '清除搜索',

    // Settings Sidebar Navigation
    'settings_section_general' => '常规',
    'settings_section_plans' => '套餐',
    'settings_section_auth' => '身份验证',
    'settings_section_email' => '邮件',
    'settings_section_privacy' => '隐私',
    'settings_section_preview' => '预览',
    'settings_section_ai' => 'AI 聊天',
    'settings_category_platform' => '平台',
    'settings_category_security' => '安全',
    'settings_category_integrations' => '集成',
    'audit_logs_subtitle' => '跟踪用户操作和系统事件以符合 GDPR',
    'no_audit_logs_found' => '未找到审计日志。',
    'search_audit_logs' => '按用户、操作、IP 搜索...',
    'date_time' => '日期/时间',
    'actor' => '操作者',
    'ip_address' => 'IP 地址',
    'details' => '详情',
    'view_details' => '查看详情',
    'system' => '系统',
    'clear_filters' => '清除筛选',
    'to' => '至',
    'settings_subtitle' => '配置系统设置',

    // Users
    'add_user' => '添加用户',
    'edit_user' => '编辑用户',
    'create_user' => '创建用户',
    'delete_user' => '删除用户',
    'user_info' => '用户信息',
    'user_details' => '用户详情',
    'no_users_found' => '未找到用户。',
    'search_users' => '搜索用户...',
    'user_role' => '角色',
    'user_plan' => '套餐',
    'user_joined' => '加入时间',
    'email_verified' => '邮箱已验证',
    'mark_email_verified' => '标记邮箱已验证',
    'role_admin' => '管理员',
    'role_user' => '用户',
    'leave_blank_password' => '留空以保持当前密码',

    // Plans
    'add_plan' => '添加套餐',
    'edit_plan' => '编辑套餐',
    'create_plan' => '创建套餐',
    'create_new_plan' => '创建新套餐',
    'update_plan' => '更新套餐',
    'delete_plan' => '删除套餐',
    'no_plans_found' => '未找到套餐。',
    'plan_features' => '功能',
    'plan_price' => '价格',
    'plan_interval' => '计费周期',
    'monthly' => '每月',
    'yearly' => '每年',
    'default_plan' => '默认套餐',
    'mark_as_default' => '标记为默认套餐',
    'per_month' => '/月',
    'subscribers' => '订阅者',
    'plan_name' => '套餐名称',
    'plan_name_placeholder' => '专业版',
    'basic_information' => '基本信息',
    'usage_limits' => '使用限制',
    'monthly_build_credits' => '每月构建积分',
    'unlimited' => '无限',
    'appetize_preview' => 'Appetize 预览',
    'hosted_pages' => '托管页面',
    'ai_assistant' => 'AI 助手',
    'allow_own_api_keys' => '允许使用自己的 API 密钥',
    'permissions' => '权限',
    'custom_css_js_injection' => '自定义 CSS/JS 注入',
    'api_access' => 'API 访问',
    'builder_access' => '构建器访问',
    'all_builders_allowed' => '允许所有构建器',
    'select_builders' => '选择构建器',
    'builders_selected' => '已选择 :count 个构建器|已选择 :count 个构建器',
    'allow_all_builders' => '允许所有构建器',
    'search_builders_placeholder' => '搜索构建器...',
    'features_pricing_display' => '功能（定价页面显示）',
    'feature_name' => '功能名称',
    'included' => '包含',
    'not_included' => '不包含',
    'no_features_added' => '尚未添加功能。添加功能以在定价页面显示。',

    // Subscriptions
    'add_subscription' => '添加订阅',
    'subscription_details' => '订阅详情',
    'no_subscriptions_found' => '未找到订阅。',
    'search_subscriptions' => '搜索订阅...',
    'renewal_date' => '续订日期',
    'subscription_status' => '状态',
    'change_plan' => '更换套餐',
    'cancel_subscription' => '取消订阅',
    'next_billing' => '下次账单',
    'no_plan' => '无套餐',
    'select_user' => '选择用户',
    'select_plan' => '选择套餐',
    'payment_method_placeholder' => '手动、银行转账等',

    // Transactions
    'transaction_details' => '交易详情',
    'no_transactions_found' => '未找到交易。',
    'search_transactions' => '搜索交易...',
    'transaction_id' => 'ID',
    'transaction_date' => '日期',
    'transaction_amount' => '金额',
    'payment_method' => '支付方式',
    'payment_gateway' => '支付网关',
    'transaction_status' => '状态',
    'approve' => '批准',
    'decline' => '拒绝',
    'confirm_approval' => '确认批准',
    'confirm_decline' => '确认拒绝',
    'approve_payment' => '批准支付',
    'decline_payment' => '拒绝支付',
    'approve_bank_transfer_confirm' => '确定要批准此银行转账支付吗？这将激活用户的订阅。',
    'decline_bank_transfer_confirm' => '确定要拒绝此银行转账支付吗？这将取消订阅并通知用户。',

    // Builders
    'add_builder' => '添加构建器',
    'edit_builder' => '编辑构建器',
    'create_builder' => '创建构建器',
    'delete_builder' => '删除构建器',
    'no_builders_found' => '未找到构建器。',
    'search_builders' => '搜索构建器...',
    'builder_name' => '构建器名称',
    'builder_url' => 'URL',
    'builder_status' => '状态',
    'builder_platform' => '平台',
    'builder_platforms' => '平台',
    'builder_name_placeholder' => '生产构建器',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => '生成的服务器密钥',
    'builder_queue' => '队列',
    'current_builds' => '当前构建',
    'total_builds' => '总构建',
    'server_url' => '服务器 URL',
    'port' => '端口',
    'server_key' => '服务器密钥',
    'server_key_help' => '用于验证对此构建器的 API 请求',
    'generate' => '生成',
    'max_queue' => '最大队列',
    'max_queue_help' => '最大并发构建数',
    'build_credit_cost' => '构建积分成本',
    'credit_cost_help' => '每次构建扣除的积分',
    'supported_platforms' => '支持的平台',
    'select_platforms' => '选择平台',
    'platforms_selected' => '已选择 :count 个平台|已选择 :count 个平台',
    'platforms_help' => '选择此构建器支持的一个或多个平台',
    'no_platforms_available' => '无可用平台',
    'no_builders_configured' => '尚未配置构建器。',
    'default' => '默认',
    'locked' => '已锁定',
    'from_purchase_code' => '来自购买代码',
    'purchase_code_not_set_warning' => '未配置购买代码',
    'purchase_code_not_set_description' => '默认构建器需要有效的购买代码。请在设置 > 常规中配置。',
    'server_key_from_purchase_code_help' => '服务器密钥从您的购买代码自动设置。',

    // Plugins
    'upload_plugin' => '上传插件',
    'configure_plugin' => '配置',
    'delete_plugin' => '删除插件',
    'no_plugins_found' => '未找到插件。',
    'plugin_name' => '名称',
    'plugin_version' => '版本',
    'plugin_type' => '类型',
    'plugin_status' => '状态',

    // Languages
    'add_language' => '添加语言',
    'add_new_language' => '添加新语言',
    'edit_language' => '编辑语言',
    'create_language' => '创建语言',
    'delete_language' => '删除语言',
    'no_languages_found' => '未找到语言。',
    'cannot_delete_default_language' => '无法删除默认或主要语言。',
    'default_language_badge' => '默认',
    'language_name' => '语言名称',
    'language_code' => '语言代码',
    'language_code_help' => '2 字符 ISO 639-1 代码（例如：en、es、fr）',
    'language_code_from_folder' => '从可用翻译文件夹中选择',
    'language_flag' => '国旗',
    'language_flag_help' => '国家国旗 emoji',
    'language_flag_auto' => '国旗根据语言代码自动设置',
    'language_flag_country_code_help' => '2 字符国家代码（例如：us、gb、es）',
    'language_name_placeholder' => '英语',
    'language_code_placeholder' => 'en',
    'language_flag_placeholder' => '🇺🇸',
    'language_status' => '状态',
    'rtl_support' => '文字方向',
    'rtl_enabled' => '从右到左（RTL）',
    'rtl_description' => '为阿拉伯语、希伯来语、波斯语和乌尔都语等语言启用',
    'translation_files_created' => '翻译文件将创建在：lang/:code/',
    'translation_files_auto_created' => '添加此语言前请确保翻译文件存在于 :path。复制 lang/en/ 文件夹，重命名为您的语言代码，然后翻译内容。',

    // Email Templates
    'edit_template' => '编辑模板',
    'edit_email_template' => '编辑邮件模板',
    'reset_template' => '重置为默认',
    'no_templates_found' => '未找到模板。',
    'template_subject' => '主题',
    'template_body' => '内容',
    'template_variables' => '可用变量',
    'subject_line' => '主题行',
    'email_subject_placeholder' => '邮件主题...',
    'email_body' => '邮件内容',
    'click_to_insert' => '点击插入到光标位置',
    'no_variables_available' => '此模板没有可用变量。',
    'quick_tips' => '快速提示',
    'variables_replaced' => '发送时变量将被真实数据替换',
    'toolbar_format_tip' => '使用工具栏格式化文本、添加链接和创建列表',
    'link_tip' => '选择文本并点击链接按钮添加可点击链接',

    // Cronjobs
    'no_cronjobs_found' => '未找到定时任务。',
    'no_cron_logs_found' => '未找到定时任务日志。',
    'search_logs' => '搜索日志...',
    'job_name' => '任务名称',
    'job' => '任务',
    'last_run' => '上次运行',
    'next_run' => '下次运行',
    'run_duration' => '持续时间',
    'started' => '开始时间',
    'duration' => '持续时间',
    'triggered_by' => '触发者',
    'message' => '消息',
    'all_jobs' => '所有任务',
    'trigger_manually' => '手动触发',
    'status_success' => '成功',
    'status_running' => '运行中',

    // Settings
    'general_settings' => '常规设置',
    'email_settings' => '邮件设置',
    'social_login_settings' => '社交登录',
    'appetize_settings' => 'Appetize 设置',
    'ai_settings' => 'AI 设置',
    'gdpr_settings' => 'GDPR 设置',

    // General Settings Fields
    'site_name' => '网站名称',
    'site_description' => '网站描述',
    'site_tagline' => '网站标语',
    'logo' => 'Logo',
    'logo_dark' => '深色模式 Logo',
    'favicon' => '网站图标',
    'default_theme' => '默认主题',
    'landing_page_enabled' => '启用着陆页',
    'system_currency' => '系统货币',
    'default_language' => '默认语言',
    'default_language_description' => '新访客和没有偏好设置的用户的默认语言',

    // Status Labels
    'status_active' => '活跃',
    'status_inactive' => '未激活',
    'status_pending' => '待处理',
    'status_expired' => '已过期',
    'status_cancelled' => '已取消',
    'status_completed' => '已完成',
    'status_failed' => '失败',

    // Demo Mode
    'demo_mode_notice' => '演示模式下无法修改设置。',
    'disabled_in_demo' => '演示模式下已禁用',
    'hidden_in_demo' => '演示模式下已隐藏',

    // Plugins
    'plugins_title_full' => '插件',
    'plugins_subtitle_full' => '使用自定义插件扩展功能',
    'no_plugins_installed' => '未安装任何插件',
    'plugin_activate' => '激活',
    'plugin_deactivate' => '停用',
    'plugin_uninstall' => '卸载',
    'plugin_author' => '作者：:author',

    // Languages
    'languages_title_full' => '语言',
    'languages_subtitle_full' => '管理语言翻译和本地化',

    // Cronjobs
    'cronjobs_title_full' => '定时任务',
    'cronjobs_tab_jobs' => '计划任务',
    'cronjobs_tab_logs' => '执行日志',
    'execute_job' => '执行',
    'executing_job' => '执行中...',

    // Email Settings
    'email_config_title' => '邮件配置',
    'email_config_subtitle' => '配置邮件设置和 SMTP 服务器',
    'mail_driver' => '邮件驱动',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail 使用服务器内置的邮件配置。简单但在某些服务器上可能存在送达问题。',
    'php_mail_warning' => '注意：某些主机提供商禁用了 PHP 的 mail() 函数。如果邮件无法发送，请考虑切换到 SMTP。',
    'smtp_config' => 'SMTP 服务器配置',
    'smtp_host' => 'SMTP 主机',
    'smtp_port' => 'SMTP 端口',
    'smtp_username' => 'SMTP 用户名',
    'smtp_password' => 'SMTP 密码',
    'smtp_encryption' => '加密',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => '无',
    'admin_notifications' => '管理员通知',
    'admin_email' => '管理员通知邮箱',
    'admin_email_help' => '接收管理员通知的邮箱地址。如果为空，将使用当前登录管理员的邮箱。',
    'notify_user_registered' => '新用户注册',
    'notify_subscription_created' => '新订阅创建',
    'notify_subscription_cancelled' => '订阅取消',
    'notify_payment_received' => '收到付款',
    'notify_payment_failed' => '支付失败',
    'notify_build_started' => '构建开始',
    'notify_build_completed' => '构建完成',
    'notify_build_failed' => '构建失败',
    'test_email' => '测试邮件',
    'send_test_email' => '发送测试邮件',
    'sending' => '发送中...',
    'mail_from_name' => '发件人名称',
    'mail_from_address' => '发件人地址',
    'php_mail_info' => 'PHP Mail 使用服务器内置的邮件配置（sendmail/postfix）。此面板无需额外设置。',
    'php_mail_switch_warning' => '注意：某些主机提供商禁用了 PHP 的 mail() 函数。如果邮件发送失败，请切换到 SMTP。',
    'admin_notifications_subtitle' => '配置管理员付款通知发送位置',
    'admin_email_description' => '接收管理员通知的邮箱地址。也用于测试邮件。',
    'notification_events' => '通知事件',
    'notification_events_description' => '选择哪些事件应触发管理员通知',
    'event_subscription_activated' => '订阅已激活',
    'event_payment_completed' => '支付完成',
    'event_payment_failed' => '支付失败',
    'event_subscription_cancelled' => '订阅已取消',
    'event_subscription_expired' => '订阅已过期',
    'event_bank_transfer_pending' => '银行转账待处理',
    'event_user_registered' => '用户已注册',
    'event_build_completed' => '构建已完成',
    'event_build_failed' => '构建失败',

    // Social Login Settings
    'auth_settings_title' => '身份验证设置',
    'auth_settings_subtitle' => '配置注册和社交登录选项',
    'enable_registration' => '启用注册',
    'enable_registration_description' => '允许新用户注册账户',
    'require_email_verification' => '需要邮箱验证',
    'require_email_verification_description' => '禁用时，新注册将自动验证',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => '保护身份验证表单免受机器人攻击',
    'recaptcha_site_key' => '站点密钥',
    'recaptcha_site_key_placeholder' => '您的 reCAPTCHA v3 站点密钥',
    'recaptcha_secret_key' => '密钥',
    'recaptcha_secret_key_placeholder' => '您的 reCAPTCHA v3 密钥',
    'leave_blank_keep_current' => '留空以保持当前设置',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => '客户端 ID',
    'client_id_placeholder' => '您的 :provider 客户端 ID',
    'client_secret' => '客户端密钥',
    'client_secret_placeholder' => '您的 :provider 客户端密钥',
    'app_id' => '应用 ID',
    'app_id_placeholder' => '您的 :provider 应用 ID',
    'app_secret' => '应用密钥',
    'app_secret_placeholder' => '您的 :provider 应用密钥',
    'callback_url' => '回调 URL',
    'oauth_help' => '在 :provider 开发者控制台创建 OAuth 凭据。使用上面的回调 URL。',
    'test_connection' => '测试连接',
    'testing' => '测试中...',
    'configure_oauth' => '配置 :provider OAuth 凭据',
    'add_url_to_console' => '将此 URL 添加到您的 :provider',
    'your_provider_key' => '您的 :provider :type',
    'recaptcha_help' => '从 :link 获取密钥。确保选择 reCAPTCHA v3。',
    'recaptcha_console' => 'Google reCAPTCHA 管理控制台',
    'get_api_key_from' => '从 :link 获取您的 API 密钥',

    // General Settings
    'general_settings_title' => '常规设置',
    'general_settings_subtitle' => '更新您的网站信息和品牌',
    'site_name_label' => '网站名称',
    'site_description_label' => '网站描述',
    'site_description_placeholder' => '用于 meta 描述和 SEO',
    'site_tagline_label' => '网站标语',
    'site_tagline_placeholder' => 'Logo 下方显示的短标语',
    'site_tagline_help' => '显示在侧边栏和登录页面的 Logo 下方',
    'purchase_code_label' => '购买代码',
    'purchase_code_help' => '此安装的许可证或购买代码（可选）',
    'logo_light' => 'Logo（浅色模式）',
    'logo_dark_label' => 'Logo（深色模式）',
    'delete_logo' => '删除 Logo',
    'delete_dark_logo' => '删除深色 Logo',
    'delete_favicon' => '删除网站图标',
    'logo_help' => '推荐：200x50px（横向）或 50x50px（方形）。PNG、JPG、SVG 透明背景。最大 2MB。',
    'favicon_label' => '网站图标',
    'favicon_help' => '推荐：32x32px 或 16x16px。PNG、ICO 或 SVG。最大 1MB。',
    'default_theme_label' => '默认颜色主题',
    'theme_system' => '系统（跟随用户设备偏好）',
    'theme_light' => '浅色',
    'theme_dark' => '深色',
    'theme_help' => '新访客的默认主题。用户可以在设置中更改。',
    'currency_label' => '系统货币',
    'currency_help' => '用于所有定价和支付的货币。这决定了哪些支付网关可用。',
    'landing_page_toggle' => '启用公共着陆页',
    'landing_page_help' => '禁用时，访问根 URL（/）的访客将被重定向到登录页面',

    // Plan Configuration Settings
    'plan_config_title' => '套餐配置',
    'plan_config_subtitle' => '为新用户配置默认套餐设置',
    'default_plan_label' => '默认套餐',
    'default_plan_none' => '无（需要订阅）',
    'default_plan_help' => '注册时分配给新用户的套餐。如果未选择套餐，用户需要订阅才能访问功能。',

    // AI Settings
    'ai_settings_title' => 'AI 聊天助手',
    'ai_settings_subtitle' => '配置 AI 驱动的应用创建助手',
    'enable_ai' => '启用 AI 聊天助手',
    'enable_ai_description' => '允许用户通过 AI 对话创建和配置应用',
    'enable_streaming' => '启用流式响应',
    'enable_streaming_description' => '逐字流式传输 AI 响应以获得更互动的体验',
    'streaming_warning' => '可能在某些共享主机环境中不起作用',
    'ai_provider' => 'AI 提供商',
    'ai_provider_help' => '在 OpenAI（GPT-4.1）或 Anthropic（Claude）之间选择',
    'api_key' => 'API 密钥',
    'enter_api_key' => '输入您的 API 密钥',
    'openai_console' => 'OpenAI 控制台',
    'anthropic_console' => 'Anthropic 控制台',
    'api_key_help' => '从 :provider 获取您的 API 密钥',
    'advanced_settings' => '高级设置',
    'ai_model' => 'AI 模型',
    'ai_model_help' => '选择用于聊天响应的 AI 模型',
    'temperature' => '温度',
    'temperature_help' => '控制随机性。较低 = 更集中，较高 = 更有创意',
    'max_tokens' => '最大响应令牌数',
    'max_tokens_help' => '每个 AI 响应的最大令牌数。较高的值 = 更长的响应但成本更高',
    'auto_summarization' => '自动摘要',
    'enable_summarization' => '启用自动摘要',
    'summarization_help' => '自动摘要旧消息以减少长对话中的令牌使用',
    'summarization_threshold' => '摘要阈值',
    'summarization_threshold_help' => '触发自动摘要前的消息数',
    'summarization_keep_recent' => '保留最近消息',
    'summarization_keep_recent_help' => '要保留的最近消息数',
    'summarization_max_length' => '最大摘要长度',
    'summarization_max_length_help' => '摘要的最大字符数',
    'chat_widget' => '聊天小部件',
    'widget_position' => '小部件位置',
    'position_bottom_right' => '右下',
    'position_bottom_left' => '左下',
    'position_top_right' => '右上',
    'position_top_left' => '左上',
    'position_help' => 'AI 聊天小部件在应用编辑器页面上的显示位置',

    // GDPR Settings
    'gdpr_settings_title' => 'GDPR 设置',
    'gdpr_settings_subtitle' => '配置 GDPR 合规和隐私设置',
    'enable_cookie_consent' => '启用 Cookie 同意横幅',
    'enable_data_export' => '启用数据导出',
    'enable_account_deletion' => '启用账户删除',
    'deletion_grace_period' => '账户删除宽限期（天）',
    'audit_log_retention' => '审计日志保留期（天）',

    // Appetize Settings
    'appetize_settings_title' => 'Appetize 设置',
    'appetize_settings_subtitle' => '配置 Appetize.io 以进行实时应用预览',
    'appetize_api_token' => 'Appetize API 令牌',
    'appetize_api_token_help' => '从您的 Appetize.io 仪表盘获取 API 令牌',

    // Delete/Action Modal Messages
    'delete_user_confirm' => '确定要删除',
    'delete_builder_confirm' => '确定要删除',
    'delete_plan_confirm' => '确定要删除',
    'delete_plan_confirm_suffix' => '套餐吗？',
    'delete_language_confirm' => '确定要删除',
    'delete_language_note' => '此操作无法撤销。翻译文件将保留以确保数据安全。',
    'uninstall_plugin' => '卸载插件',
    'uninstall_plugin_confirm' => '确定要卸载',
    'cancel_subscription_confirm' => '确定要取消以下用户的订阅',
    'reset_email_template' => '重置邮件模板',
    'reset_template_confirm' => '确定要重置',
    'reset_template_confirm_suffix' => '为默认内容吗？',
    'reset_template_warning' => '您所做的任何自定义都将丢失。',
    'disabled_in_demo' => '演示模式下已禁用',

    // Plugin Upload Modal
    'plugin_file' => '插件文件',
    'plugin_file_help' => 'ZIP 文件（最大 10MB）',
    'installing_plugin' => '正在安装插件...',
    'installing' => '安装中...',

    // Plugin Config Modal
    'configure_plugin_title' => '配置 :name',
    'no_config_required' => '无需配置',
    'no_config_required_desc' => '此插件不需要任何配置。',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Appetize.io 集成',
    'appetize_integration_subtitle' => '配置实时应用预览功能',
    'enable_appetize_integration' => '启用 Appetize.io 集成',
    'enable_appetize_description' => '允许专业版/企业版用户在浏览器中预览应用',
    'appetize_api_token_placeholder' => '输入您的 Appetize.io API 令牌',
    'appetize_api_token_link' => '从以下位置获取您的 API 令牌',
    'auto_upload_builds' => '自动上传构建到 Appetize',
    'auto_upload_description' => '自动上传成功的构建以进行即时预览',
    'preview_retention_days' => '预览保留期（天）',
    'preview_retention_help' => '在此天数后删除旧预览以节省成本（1-30 天）',
    'session_timeout_seconds' => '会话超时（秒）',
    'session_timeout_help' => '会话结束前的不活动超时时间',
    'seconds_30' => '30 秒',
    'minute_1' => '1 分钟',
    'minutes_2' => '2 分钟',
    'minutes_3' => '3 分钟',
    'minutes_5' => '5 分钟',
    'minutes_10' => '10 分钟',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'GDPR 和隐私设置',
    'gdpr_privacy_settings_subtitle' => '配置数据保护和隐私合规',
    'feature_toggles' => '功能开关',
    'cookie_consent_banner' => 'Cookie 同意横幅',
    'cookie_consent_description' => '向新访客显示 Cookie 同意横幅',
    'user_data_export' => '用户数据导出',
    'user_data_export_description' => '允许用户请求其数据副本',
    'user_account_deletion' => '用户账户删除',
    'user_account_deletion_description' => '允许用户请求账户删除',
    'policy_versions' => '政策版本',
    'policy_versions_help' => '更新政策版本将触发用户重新同意。',
    'privacy_policy' => '隐私政策',
    'terms_of_service' => '服务条款',
    'cookie_policy' => 'Cookie 政策',
    'data_retention_periods' => '数据保留期（天）',
    'retention_transactions' => '交易',
    'retention_transactions_help' => '最少 365 天（法律要求）',
    'retention_inactive_accounts' => '不活跃账户',
    'retention_expired_builds' => '过期构建',
    'retention_audit_logs' => '审计日志',
    'retention_data_exports' => '数据导出',
    'grace_periods_rate_limits' => '宽限期和频率限制',
    'account_deletion_grace_period' => '账户删除宽限期（天）',
    'account_deletion_grace_help' => '账户永久删除前的时间',
    'data_export_rate_limit' => '数据导出频率限制（小时）',
    'data_export_rate_limit_help' => '导出请求之间的最短时间',

    // App/Plan Settings
    'plan_configuration' => '套餐配置',
    'plan_configuration_subtitle' => '为新用户配置默认套餐设置',
    'default_plan_option_none' => '无（需要订阅）',
    'default_plan_description' => '分配给新用户的套餐。选择"无"以要求订阅后才能使用。',

    // Overview Stats
    'overview_subtitle' => '系统范围的统计数据和管理指标',
    'date_range_today' => '今天',
    'date_range_week' => '本周',
    'date_range_month' => '本月',
    'date_range_year' => '本年',
    'date_range_all' => '全部',
    'auto_refresh' => '自动刷新',
    'total_system_users' => '系统总用户',
    'active_subscriptions' => '活跃订阅',
    'revenue_label' => ':period 收入',
    'total_apps' => '总应用数',
    'vs_last_month' => '与上月相比',
    'total_builds_stat' => '总构建数',
    'completed_today' => '今日完成',
    'build_success_rate' => '构建成功率',
    'pending_queue' => '待处理队列',
    'total_transactions' => '总交易数',
    'active_plans' => '活跃套餐',
    'active_builders' => '活跃构建器',
    'revenue_trends' => '收入趋势（12 个月）',
    'build_activity' => '构建活动（过去 30 天）',
    'revenue_by_gateway' => '按支付网关的收入',
    'no_revenue_data' => '暂无收入数据',
    'total_revenue' => '总收入',
    'platform_distribution' => '平台分布',
    'no_apps_created' => '暂无应用创建',
    'pending_payments' => '待处理支付',
    'active_users_7d' => '活跃用户（7 天）',
    'notifications_today' => '今日通知',
    'build_performance_by_platform' => '按平台的构建性能',
    'platform' => '平台',
    'completed' => '已完成',
    'failed' => '失败',
    'success_rate' => '成功率',
    'avg_duration' => '平均时长',
    'revenue_label_short' => '收入',
    'builds_label' => '构建',
    'recent_user_registrations' => '最近用户注册',
    'no_users_yet' => '暂无用户',
    'recent_builds' => '最近构建',
    'no_builds_yet' => '暂无构建',
    'recent_transactions' => '最近交易',
    'no_transactions_yet' => '暂无交易',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => '任务',
    'cronjobs_tab_execution_logs' => '执行日志',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'API 凭据',
        'webhook_configuration' => 'Webhook 配置',
        'webhook_url' => 'Webhook URL',
        'copy' => '复制',
        'copied' => '已复制！',
        'copy_failed' => '复制失败。请手动选择并复制 URL。',
        'required_webhook_events' => '必需的 Webhook 事件',
        'features' => '功能',
        'supported_features' => '支持的功能',
        'secret_key' => '密钥',
        'webhook_secret' => 'Webhook 密钥',
        'webhook_signing_secret' => 'Webhook 签名密钥',
        'optional' => '可选',

        // SSL Warning
        'ssl_warning' => '警告：',
        'ssl_warning_stripe' => '您的网站未使用 HTTPS。Stripe 要求 HTTPS 用于 webhooks 和生产使用。',
        'ssl_warning_paypal' => '您的网站未使用 HTTPS。PayPal webhooks 需要安全的 HTTPS 连接。请在上线前启用 SSL/TLS。',
        'ssl_warning_paystack' => '您的网站未使用 HTTPS。Paystack webhooks 需要安全的 HTTPS 连接。请在上线前启用 SSL/TLS。',

        // Stripe
        'stripe' => [
            'get_started' => '开始使用 Stripe',
            'get_api_keys' => '从以下位置获取 API 密钥',
            'dashboard_link' => 'Stripe 仪表盘 → 开发者 → API 密钥',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => '使用测试密钥（sk_test_）进行测试，使用正式密钥（sk_live_）用于生产',
            'webhook_url_help' => '在 Stripe 仪表盘 → 开发者 → Webhooks 中添加此 URL',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => '在 Stripe 仪表盘创建 webhook 端点后获取',
            'events_help' => '创建 webhook 端点时选择这些事件：',
            'feature_currencies' => '全球支持 135+ 种货币',
            'feature_intervals' => '支持所有计费周期',
            'feature_renewal' => '自动订阅续订',
            'feature_customer_management' => '客户管理',
            'feature_signature_verification' => 'Webhook 签名验证',
            'feature_refund' => '退款处理',
            'feature_sca' => '符合强客户身份验证（SCA）',
        ],

        // PayPal
        'paypal' => [
            'client_id' => '客户端 ID',
            'client_id_help' => '从 PayPal 开发者仪表盘获取',
            'client_secret' => '客户端密钥',
            'client_secret_help' => '保持机密，切勿公开分享',
            'sandbox_mode' => '沙盒模式',
            'sandbox_mode_help' => '启用以使用 PayPal 沙盒进行测试。禁用以进行正式交易。',
            'webhook_url_help' => '将此 URL 添加到您的 PayPal webhook 设置',
            'webhook_id' => 'Webhook ID',
            'webhook_id_help' => '来自 PayPal 仪表盘的 Webhook ID 用于签名验证（安全所需）',
            'events_help' => '确保在 PayPal webhook 配置中启用这些事件：',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => '开始使用 Razorpay',
            'get_api_keys' => '从以下位置获取 API 密钥',
            'dashboard_link' => 'Razorpay 仪表盘 → 设置 → API 密钥',
            'key_id' => '密钥 ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => '使用测试密钥（rzp_test_）进行测试，使用正式密钥（rzp_live_）用于生产',
            'key_secret' => '密钥密码',
            'key_secret_help' => '保持机密，切勿公开分享',
            'webhook_url_help' => '在 Razorpay 仪表盘 → 设置 → Webhooks 中添加此 URL',
            'webhook_secret_placeholder' => '输入 webhook 密钥',
            'webhook_secret_help' => '创建 webhook 后从 Razorpay 仪表盘获取',
            'events_help' => '在 Razorpay 仪表盘 → 设置 → Webhooks 中启用这些事件：',
            'feature_currencies' => '支持 100+ 种货币',
            'feature_intervals' => '所有计费周期（每日、每周、每月、每年）',
            'feature_payment_methods' => 'UPI、卡、网银、钱包、EMI',
            'feature_renewal' => '自动订阅续订',
            'feature_signature_verification' => 'Webhook 签名验证',
            'feature_refund' => '退款处理',
            'feature_decimal' => '三位小数货币支持（KWD、BHD 等）',
        ],

        // Paystack
        'paystack' => [
            'get_started' => '开始使用 Paystack',
            'get_api_keys' => '从以下位置获取 API 密钥',
            'dashboard_link' => 'Paystack 仪表盘 → 设置 → API 密钥和 Webhooks',
            'secret_key_help' => '从 Paystack 仪表盘获取（使用测试密钥进行测试，正式密钥用于生产）',
            'webhook_url_help' => '将此 URL 添加到您的 Paystack webhook 设置',
            'webhook_secret_help' => '可选：用于 webhook 签名验证（生产环境推荐）',
            'webhook_secret_placeholder' => '留空以跳过签名验证',
            'events_help' => '在 Paystack 仪表盘 → 设置 → API 密钥和 Webhooks 中启用这些事件：',
            'feature_currencies' => '货币：NGN、USD、GHS、ZAR、KES',
            'feature_intervals' => '周期：每日、每周、每月（1、3、6 个月）、每年',
            'feature_renewal' => '自动订阅续订',
            'feature_signature_verification' => 'Webhook 签名验证',
            'feature_interval_limitation' => '有限的周期支持（见文档）',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => '开始使用 Crypto.com Pay',
            'get_api_keys' => '从以下位置获取 API 凭据',
            'dashboard_link' => 'Crypto.com Pay 仪表盘',
            'monthly_only_title' => '仅支持月度周期',
            'monthly_only_description' => 'Crypto.com Pay 目前仅支持月度计费周期。不支持每日、每周和每年订阅。',
            'secret_key_placeholder' => '输入您的 Crypto.com Pay 密钥',
            'secret_key_help' => '从 Crypto.com Pay 仪表盘获取',
            'webhook_url_help' => '将此 URL 添加到您的 Crypto.com Pay webhook 设置',
            'webhook_secret_placeholder' => '输入 webhook 签名密钥',
            'webhook_secret_help' => 'webhook 签名验证所需',
            'events_help' => '在 Crypto.com Pay 仪表盘中启用这些事件：',
            'feature_crypto_fiat' => '接受加密货币和法币支付',
            'feature_currencies' => '支持 30+ 种货币',
            'feature_renewal' => '自动订阅续订',
            'feature_signature_verification' => 'HMAC SHA-256 webhook 签名验证',
            'feature_monthly_only' => '仅月度周期（不支持每日/每周/每年）',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => '需要手动批准',
            'manual_approval_description' => '银行转账支付需要手动验证。用户发起支付后将看到以下说明。管理员必须在以下位置批准或拒绝支付',
            'transactions_link' => '交易',
            'instructions_title' => '银行转账说明',
            'instructions_label' => '用户说明',
            'instructions_placeholder' => "在此输入您的银行账户详情和转账说明...\n\n示例：\n\n银行名称：ABC 银行\n账户名称：您的公司名称\n账户号码：123456789\nSwift 代码：ABCDEFGH\n参考号：[用户将看到其订阅 ID]\n\n请在银行转账中包含您的订阅 ID，并将付款证明发送至 billing@yourcompany.com",
            'instructions_help' => '用户选择套餐后将显示这些说明。包括银行账户详情、参考格式和任何验证步骤。',
            'workflow_title' => '银行转账支付的工作流程：',
            'workflow_step_1' => '用户选择套餐并选择银行转账作为支付方式',
            'workflow_step_2' => '创建待处理的订阅和交易',
            'workflow_step_3' => '用户看到您上面配置的说明',
            'workflow_step_4' => '用户手动完成银行转账',
            'workflow_step_5' => '管理员收到待处理支付通知',
            'workflow_step_6' => '管理员批准支付 → 订阅激活并补充积分',
            'workflow_step_7' => '管理员拒绝支付 → 删除订阅和交易',
            'feature_currencies' => '支持所有货币',
            'feature_intervals' => '支持所有计费周期（每日、每周、每月、每年）',
            'feature_simple_setup' => '简单设置 - 无需 API 凭据',
            'feature_manual_verification' => '手动验证确保安全',
            'feature_no_fees' => '无交易费用或第三方依赖',
            'feature_admin_approval' => '每次支付需要管理员批准',
            'feature_no_renewal' => '无自动订阅续订',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => '无限构建积分',
    'feature_build_credits' => ':count 构建积分',
    'feature_all_builders' => '访问所有活跃构建器',
    'feature_builder_access' => '构建器访问',
    'feature_single_builder' => '访问单个构建器',
    'feature_multiple_builders' => '访问 :count 个构建器',
    'feature_custom_code' => '自定义 CSS/JS 注入',
    'feature_api_access' => 'API 访问',
    'feature_unlimited_hosted_pages' => '无限托管页面',
    'feature_hosted_pages' => '每应用 :count 个托管页面',
    'feature_hosted_pages_disabled' => '托管页面',
    'feature_unlimited_ai_chat' => '无限 AI 聊天',
    'feature_ai_tokens' => ':count AI 令牌/月',
    'feature_own_ai_key' => '使用您自己的 AI API 密钥',
    'feature_ai_chat' => 'AI 聊天助手',

    // Impersonation
    'impersonate' => '模拟',
    'impersonate_user' => '模拟用户',
    'impersonation_started' => '现在正在模拟 :name',
    'impersonation_stopped' => '模拟已结束。欢迎回来！',
    'impersonating_as' => '以 :name 身份查看',
    'exit_impersonation' => '退出',
    'return_to_admin' => '返回管理',
    'not_impersonating' => '当前未模拟任何用户。',
    'admin_blocked_during_impersonation' => '模拟期间管理区域被阻止。请先退出模拟。',
    'impersonation_disabled_demo' => '演示模式下禁用模拟。',
    'only_admins_can_impersonate' => '只有管理员可以模拟用户。',
];
