<div class="bg-white border border-gray-200 rounded-lg shadow-xs dark:bg-gray-800 dark:border-gray-700">
    <div class="p-6 border-b border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ __('admin.plan_configuration') }}</h3>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">{{ __('admin.plan_configuration_subtitle') }}</p>
    </div>
    <form wire:submit="save" class="p-6 space-y-4">
        <!-- Default Plan -->
        <div>
            <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.default_plan_label') }}</label>
            <select wire:model="default_plan_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                <option value="">{{ __('admin.default_plan_option_none') }}</option>
                @foreach($plans as $plan)
                    <option value="{{ $plan->id }}">{{ $plan->name }} - {{ \App\Helpers\CurrencyHelper::format($plan->price) }}{{ __('admin.per_month') }}</option>
                @endforeach
            </select>
            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.default_plan_description') }}</p>
            @error('default_plan_id') <span class="text-sm text-red-600 dark:text-red-400">{{ $message }}</span> @enderror
        </div>

        @if(config('app.demo'))
            <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}" class="text-white bg-blue-700 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 cursor-not-allowed opacity-50">
                {{ __('common.save') }}
            </button>
        @else
            <button type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-hidden dark:focus:ring-blue-800">
                {{ __('common.save') }}
            </button>
        @endif
    </form>
</div>
