<div>
    <!-- Search and Filters Bar -->
    <div class="flex flex-col items-center justify-between mb-4 space-y-3 md:flex-row md:space-y-0 md:space-x-4">
        <!-- Search -->
        <div class="w-full md:w-1/2">
            <form class="flex items-center">
                <label for="logs-search" class="sr-only">{{ __('common.search') }}</label>
                <div class="relative w-full">
                    <div class="absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <input type="text"
                           wire:model.live.debounce.300ms="search"
                           id="logs-search"
                           class="block w-full p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                           placeholder="{{ __('admin.search_logs') }}">
                </div>
            </form>
        </div>

        <!-- Filters -->
        <div class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
            <!-- Status Filter -->
            <button id="statusFilterDropdown" data-dropdown-toggle="statusDropdown" type="button" class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg md:w-auto focus:outline-hidden hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" class="w-4 h-4 me-2 text-gray-400" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z" clip-rule="evenodd" />
                </svg>
                {{ __('common.status') }}
                <svg class="-me-1 ms-1.5 w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path clip-rule="evenodd" fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" />
                </svg>
            </button>
            <div id="statusDropdown" class="z-10 hidden w-48 p-3 bg-white rounded-lg shadow dark:bg-gray-700">
                <h6 class="mb-3 text-sm font-medium text-gray-900 dark:text-white">{{ __('common.status') }}</h6>
                <ul class="space-y-2 text-sm" aria-labelledby="statusFilterDropdown">
                    <li class="flex items-center">
                        <input id="status-success" type="checkbox" wire:model.live="statusFilter" value="success" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                        <label for="status-success" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('admin.status_success') }}</label>
                    </li>
                    <li class="flex items-center">
                        <input id="status-failed" type="checkbox" wire:model.live="statusFilter" value="failed" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                        <label for="status-failed" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('common.failed') }}</label>
                    </li>
                    <li class="flex items-center">
                        <input id="status-running" type="checkbox" wire:model.live="statusFilter" value="running" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                        <label for="status-running" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('admin.status_running') }}</label>
                    </li>
                </ul>
            </div>

            <!-- Job Filter -->
            <select wire:model.live="jobFilter"
                    class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg md:w-auto focus:outline-hidden hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                <option value="">{{ __('admin.all_jobs') }}</option>
                @foreach($availableJobs as $job)
                    <option value="{{ $job }}">{{ $job }}</option>
                @endforeach
            </select>
        </div>
    </div>

    <!-- Table -->
    <div class="overflow-x-auto">
        <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">{{ __('admin.job') }}</th>
                    <th scope="col" class="px-6 py-3">{{ __('common.status') }}</th>
                    <th scope="col" class="px-6 py-3">{{ __('admin.started') }}</th>
                    <th scope="col" class="px-6 py-3">{{ __('admin.duration') }}</th>
                    <th scope="col" class="px-6 py-3">{{ __('admin.triggered_by') }}</th>
                    <th scope="col" class="px-6 py-3">{{ __('admin.message') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse($logs as $log)
                    <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600">
                        <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">
                            {{ $log->job_name }}
                        </td>
                        <td class="px-6 py-4">
                            @if($log->status === 'success')
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300">
                                    {{ __('admin.status_success') }}
                                </span>
                            @elseif($log->status === 'failed')
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300">
                                    {{ __('common.failed') }}
                                </span>
                            @else
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300">
                                    {{ __('admin.status_running') }}
                                </span>
                            @endif
                        </td>
                        <td class="px-6 py-4 text-xs">
                            {{ $log->started_at->format('M d, Y H:i:s') }}
                        </td>
                        <td class="px-6 py-4">
                            {{ $log->human_duration }}
                        </td>
                        <td class="px-6 py-4 text-xs">
                            {{ $log->triggered_by }}
                        </td>
                        <td class="px-6 py-4 text-xs">
                            {{ Str::limit($log->message, 50) }}
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                            {{ __('admin.no_cron_logs_found') }}
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <x-table-pagination :paginator="$logs" />
</div>
