<div>
    @if($isImpersonating)
    <div class="bg-amber-50 border-b border-amber-200 dark:bg-amber-900/20 dark:border-amber-800">
        <div class="flex items-center justify-between px-4 py-2.5 max-w-7xl mx-auto">
            <div class="flex items-center gap-2.5">
                <div class="flex items-center justify-center w-6 h-6 bg-amber-100 dark:bg-amber-900/50 rounded-full">
                    <svg class="w-3.5 h-3.5 text-amber-600 dark:text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z"/>
                    </svg>
                </div>
                <span class="text-sm text-amber-800 dark:text-amber-200">
                    {{ __('admin.impersonating_as', ['name' => $impersonatedUserName]) }}
                </span>
            </div>
            <form action="{{ route('admin.impersonate.stop') }}" method="POST">
                @csrf
                <button type="submit" class="inline-flex items-center gap-1.5 px-3 py-1.5 text-sm font-medium text-amber-700 dark:text-amber-300 bg-white dark:bg-gray-800 border border-amber-300 dark:border-amber-700 rounded-lg hover:bg-amber-50 dark:hover:bg-amber-900/30 focus:outline-none focus:ring-2 focus:ring-amber-500 transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                    </svg>
                    {{ __('admin.exit_impersonation') }}
                </button>
            </form>
        </div>
    </div>
    @endif
</div>
