<x-app-layout>
    <x-slot name="title">{{ __('user.api_keys_title') }}</x-slot>

    <!-- Page Header (Purple Theme) -->
    <div class="flex items-center justify-between mb-6">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-purple-100 dark:bg-purple-900 rounded-lg flex items-center justify-center">
                <svg class="w-5 h-5 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.75 5.25a3 3 0 0 1 3 3m3 0a6 6 0 0 1-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1 1 21.75 8.25Z"/>
                </svg>
            </div>
            <div>
                <h1 class="text-2xl font-bold text-gray-900 dark:text-white">{{ __('user.api_keys_title') }}</h1>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-1 hidden sm:block">
                    {{ __('user.api_keys_subtitle') }}
                </p>
            </div>
        </div>
        @if(auth()->user()->canUseApi())
            <button type="button" onclick="Livewire.dispatch('open-create-api-key-modal')" class="flex items-center gap-2 px-4 py-2.5 text-sm font-semibold text-white bg-purple-600 rounded-lg hover:bg-purple-700 focus:ring-4 focus:outline-hidden focus:ring-purple-300 dark:bg-purple-600 dark:hover:bg-purple-700 dark:focus:ring-purple-800">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                </svg>
                <span class="hidden sm:inline">{{ __('user.create_api_key') }}</span>
            </button>
        @endif
    </div>

    <!-- API Keys Table -->
    <livewire:user.api-keys-table />

    @push('modals')
        <livewire:user.create-api-key-modal />
        <livewire:user.delete-api-key-modal />
    @endpush
</x-app-layout>
